/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.heat.HeatingCrucibleTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.Property;

public class HeatingCrucibleRenderer
extends TileEntityRenderer<HeatingCrucibleTileEntity> {
    protected HeatingCrucibleRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(HeatingCrucibleTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        if (te.getActiveTexture() == null || te.func_195044_w().func_177230_c() != CRBlocks.heatingCrucible) {
            return;
        }
        int fullness = (Integer)te.func_195044_w().func_177229_b((Property)CRProperties.FULLNESS);
        if (fullness == 0) {
            return;
        }
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228645_f_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(te.getActiveTexture());
        int light = CRRenderUtil.calcMediumLighting(combinedLight);
        float xzStart = 0.125f;
        float xzEnd = 0.875f;
        float height = (float)(2 + 4 * fullness) / 16.0f;
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)xzEnd, (float)height, (float)xzStart, (float)sprite.func_94214_a((double)(xzEnd * 16.0f)), (float)sprite.func_94207_b((double)(16.0f - xzStart * 16.0f)), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)xzStart, (float)height, (float)xzStart, (float)sprite.func_94214_a((double)(xzStart * 16.0f)), (float)sprite.func_94207_b((double)(16.0f - xzStart * 16.0f)), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)xzStart, (float)height, (float)xzEnd, (float)sprite.func_94214_a((double)(xzStart * 16.0f)), (float)sprite.func_94207_b((double)(16.0f - xzEnd * 16.0f)), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)xzEnd, (float)height, (float)xzEnd, (float)sprite.func_94214_a((double)(xzEnd * 16.0f)), (float)sprite.func_94207_b((double)(16.0f - xzEnd * 16.0f)), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
    }
}

