/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.blocks.rotary.RotaryDrill;
import com.Da_Technomancer.crossroads.render.CRRenderTypes;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.rotary.RotaryDrillTileEntity;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.common.util.LazyOptional;

public class RotaryDrillRenderer
extends TileEntityRenderer<RotaryDrillTileEntity> {
    protected RotaryDrillRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(RotaryDrillTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        BlockState state = te.func_195044_w();
        LazyOptional<IAxleHandler> axle = te.getCapability(Capabilities.AXLE_CAPABILITY, null);
        if (!(state.func_177230_c() instanceof RotaryDrill) || !axle.isPresent()) {
            return;
        }
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        Direction dir = (Direction)state.func_177229_b((Property)ESProperties.FACING);
        matrix.func_227863_a_(dir.func_229384_a_());
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((IAxleHandler)axle.orElseThrow(NullPointerException::new)).getAngle(partialTicks) * (float)dir.func_176743_c().func_179524_a()));
        TextureAtlasSprite sprite = CRRenderUtil.getTextureSprite(CRRenderTypes.DRILL_TEXTURE);
        int[] col = new int[]{255, 255, te.isGolden() ? 38 : 255, 255};
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228639_c_());
        RotaryDrillRenderer.renderLayer(builder, matrix, -8.0f, 10.0f, sprite, col, combinedLight);
        RotaryDrillRenderer.renderLayer(builder, matrix, -2.0f, 6.0f, sprite, col, combinedLight);
        RotaryDrillRenderer.renderLayer(builder, matrix, 4.0f, 2.0f, sprite, col, combinedLight);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(45.0f));
        RotaryDrillRenderer.renderLayer(builder, matrix, -5.0f, 8.0f, sprite, col, combinedLight);
        RotaryDrillRenderer.renderLayer(builder, matrix, 1.0f, 4.0f, sprite, col, combinedLight);
    }

    private static void renderLayer(IVertexBuilder builder, MatrixStack matrix, float bottom, float width, TextureAtlasSprite sprite, int[] color, int light) {
        float height = 0.1875f;
        float top = (bottom /= 16.0f) + height;
        float texHeight = 3.0f;
        float texWidth = width;
        float start = -(width /= 16.0f) / 2.0f;
        float end = width / 2.0f;
        float uSt = sprite.func_94209_e();
        float uEn = sprite.func_94214_a((double)texWidth);
        float uHe = sprite.func_94214_a((double)texHeight);
        float vSt = sprite.func_94206_g();
        float vEn = sprite.func_94207_b((double)texWidth);
        float vHe = sprite.func_94207_b((double)texHeight);
        CRRenderUtil.addVertexBlock(builder, matrix, start, top, start, uSt, vSt, 0.0f, 1.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, top, end, uSt, vEn, 0.0f, 1.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, top, end, uEn, vEn, 0.0f, 1.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, top, start, uEn, vSt, 0.0f, 1.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, bottom, start, uSt, vSt, 0.0f, -1.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, bottom, start, uEn, vSt, 0.0f, -1.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, bottom, end, uEn, vEn, 0.0f, -1.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, bottom, end, uSt, vEn, 0.0f, -1.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, bottom, start, uSt, vSt, 0.0f, 0.0f, -1.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, top, start, uSt, vHe, 0.0f, 0.0f, -1.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, top, start, uEn, vHe, 0.0f, 0.0f, -1.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, bottom, start, uEn, vSt, 0.0f, 0.0f, -1.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, bottom, end, uSt, vSt, 0.0f, 0.0f, 1.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, bottom, end, uHe, vSt, 0.0f, 0.0f, 1.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, top, end, uHe, vEn, 0.0f, 0.0f, 1.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, top, end, uSt, vEn, 0.0f, 0.0f, 1.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, bottom, end, uSt, vSt, -1.0f, 0.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, top, end, uHe, vSt, -1.0f, 0.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, top, start, uHe, vEn, -1.0f, 0.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, start, bottom, start, uSt, vEn, -1.0f, 0.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, bottom, end, uSt, vSt, 1.0f, 0.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, bottom, start, uSt, vEn, 1.0f, 0.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, top, start, uHe, vEn, 1.0f, 0.0f, 0.0f, light, color);
        CRRenderUtil.addVertexBlock(builder, matrix, end, top, end, uHe, vSt, 1.0f, 0.0f, 0.0f, light, color);
    }
}

