/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.render.TESR;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.render.CRRenderTypes;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.rotary.WindTurbineTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.common.util.LazyOptional;

public class WindTurbineRenderer
extends TileEntityRenderer<WindTurbineTileEntity> {
    protected WindTurbineRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(WindTurbineTileEntity te, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        BlockState state = te.func_195044_w();
        LazyOptional<IAxleHandler> axle = te.getCapability(Capabilities.AXLE_CAPABILITY, null);
        if (state.func_177230_c() != CRBlocks.windTurbine || !axle.isPresent()) {
            return;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(CRRenderTypes.WINDMILL_TEXTURE);
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228643_e_());
        Direction facing = (Direction)state.func_177229_b((Property)CRProperties.HORIZ_FACING);
        int light = CRRenderUtil.getLightAtPos(te.func_145831_w(), te.func_174877_v().func_177972_a(facing));
        matrix.func_227860_a_();
        matrix.func_227861_a_(0.5, 0.5, 0.5);
        matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-facing.func_185119_l()));
        matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)facing.func_176743_c().func_179524_a() * ((IAxleHandler)axle.orElseThrow(NullPointerException::new)).getAngle(partialTicks)));
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.25f, (float)-0.25f, (float)0.6f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(4.0), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.25f, (float)-0.25f, (float)0.6f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(8.0), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.25f, (float)0.25f, (float)0.6f, (float)sprite.func_94214_a(4.0), (float)sprite.func_94207_b(8.0), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
        CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.25f, (float)0.25f, (float)0.6f, (float)sprite.func_94214_a(4.0), (float)sprite.func_94207_b(4.0), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
        for (int i = 0; i < 4; ++i) {
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.25f, (float)0.25f, (float)0.5f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(4.0), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.25f, (float)0.25f, (float)0.6f, (float)sprite.func_94214_a(0.8), (float)sprite.func_94207_b(4.0), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.25f, (float)0.25f, (float)0.6f, (float)sprite.func_94214_a(0.8), (float)sprite.func_94207_b(8.0), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.25f, (float)0.25f, (float)0.5f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(8.0), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.0625f, (float)0.25f, (float)0.6f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(1.5), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.0625f, (float)0.25f, (float)0.6f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(2.5), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.0625f, (float)2.0f, (float)0.6f, (float)sprite.func_94214_a(12.0), (float)sprite.func_94207_b(2.5), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.0625f, (float)2.0f, (float)0.6f, (float)sprite.func_94214_a(12.0), (float)sprite.func_94207_b(1.5), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
            Vector3d normal = CRRenderUtil.findNormal(new Vector3d(-0.0625, 0.25, 0.6), new Vector3d(-0.25, 0.25, 0.5), new Vector3d(-0.0625, 2.0, 0.6));
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.25f, (float)0.25f, (float)0.5f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(0.0), (float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c), (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.0625f, (float)0.25f, (float)0.6f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(1.5), (float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c), (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.0625f, (float)2.0f, (float)0.6f, (float)sprite.func_94214_a(12.0), (float)sprite.func_94207_b(1.5), (float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c), (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.25f, (float)2.0f, (float)0.5f, (float)sprite.func_94214_a(12.0), (float)sprite.func_94207_b(0.0), (float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c), (int)light);
            normal = CRRenderUtil.findNormal(new Vector3d(0.25, 0.25, 0.5), new Vector3d(0.0625, 0.25, 0.6), new Vector3d(0.25, 2.0, 0.5));
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.0625f, (float)0.25f, (float)0.6f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(0.0), (float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c), (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.25f, (float)0.25f, (float)0.5f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(1.5), (float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c), (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.25f, (float)2.0f, (float)0.5f, (float)sprite.func_94214_a(12.0), (float)sprite.func_94207_b(1.5), (float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c), (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.0625f, (float)2.0f, (float)0.6f, (float)sprite.func_94214_a(12.0), (float)sprite.func_94207_b(0.0), (float)((float)normal.field_72450_a), (float)((float)normal.field_72448_b), (float)((float)normal.field_72449_c), (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.25f, (float)0.25f, (float)0.5f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(0.0), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.25f, (float)2.0f, (float)0.5f, (float)sprite.func_94214_a(12.0), (float)sprite.func_94207_b(0.0), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.25f, (float)2.0f, (float)0.5f, (float)sprite.func_94214_a(12.0), (float)sprite.func_94207_b(4.0), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.25f, (float)0.25f, (float)0.5f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(4.0), (float)0.0f, (float)0.0f, (float)1.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.25f, (float)2.0f, (float)0.5f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(8.0), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)-0.0625f, (float)2.0f, (float)0.6f, (float)sprite.func_94214_a(0.8), (float)sprite.func_94207_b(6.5), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.0625f, (float)2.0f, (float)0.6f, (float)sprite.func_94214_a(0.8), (float)sprite.func_94207_b(5.5), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
            CRRenderUtil.addVertexBlock((IVertexBuilder)builder, (MatrixStack)matrix, (float)0.25f, (float)2.0f, (float)0.5f, (float)sprite.func_94214_a(0.0), (float)sprite.func_94207_b(4.0), (float)0.0f, (float)1.0f, (float)0.0f, (int)light);
            matrix.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(90.0f));
        }
        matrix.func_227865_b_();
    }
}

