/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.alchemy.GlasswareHolderTileEntity;
import com.Da_Technomancer.crossroads.tileentities.electric.TeslaCoilTopTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class ChargingStandTileEntity
extends GlasswareHolderTileEntity {
    @ObjectHolder(value="charging_stand")
    private static TileEntityType<ChargingStandTileEntity> type = null;
    private static final int ENERGY_CAPACITY = 100;
    public static final int DRAIN = 10;
    private int fe = 0;
    private final LazyOptional<IEnergyStorage> elecOpt = LazyOptional.of(() -> new ElecHandler());

    public ChargingStandTileEntity() {
        super((TileEntityType<? extends GlasswareHolderTileEntity>)type);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.fe > 0) {
            this.fe = Math.max(0, this.fe - 10);
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                CRRenderUtil.addArc(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), 1, 0.0f, TeslaCoilTopTileEntity.COLOR_CODES[(int)(this.field_145850_b.func_82737_E() % 3L)]);
            }
        }
        super.func_73660_a();
    }

    @Override
    public boolean isCharged() {
        return this.fe > 0 || super.isCharged();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.fe = nbt.func_74762_e("fe");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("fe", this.fe);
        return nbt;
    }

    @Override
    protected EnumTransferMode[] getModes() {
        return new EnumTransferMode[]{EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE};
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.elecOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.elecOpt;
        }
        if (side == Direction.UP && cap == Capabilities.CHEMICAL_CAPABILITY) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    private class ElecHandler
    implements IEnergyStorage {
        private ElecHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int toMove = Math.min(100 - ChargingStandTileEntity.this.fe, maxReceive);
            if (!simulate && toMove > 0) {
                ChargingStandTileEntity.this.fe += toMove;
                ChargingStandTileEntity.this.func_70296_d();
            }
            return toMove;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return ChargingStandTileEntity.this.fe;
        }

        public int getMaxEnergyStored() {
            return 100;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

