/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCarrierTE;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.API.alchemy.IReagent;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.SendChatToClient;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FlowLimiterTileEntity
extends AlchemyCarrierTE {
    @ObjectHolder(value="flow_limiter")
    private static TileEntityType<FlowLimiterTileEntity> type = null;
    private static final int[] LIMITS = new int[]{1, 2, 4, 8, 16, 32, 64};
    private int limitIndex = 0;
    private Direction facing = null;

    public FlowLimiterTileEntity() {
        super(type);
    }

    public FlowLimiterTileEntity(boolean glass) {
        super(type, glass);
    }

    public Direction getFacing() {
        if (this.facing == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_235901_b_((Property)ESProperties.FACING)) {
                this.facing = (Direction)state.func_177229_b((Property)ESProperties.FACING);
                return this.facing;
            }
            return Direction.DOWN;
        }
        return this.facing;
    }

    public void wrench() {
        this.facing = null;
    }

    public void cycleLimit(ServerPlayerEntity player) {
        ++this.limitIndex;
        this.limitIndex %= LIMITS.length;
        this.func_70296_d();
        ArrayList<ITextComponent> chat = new ArrayList<ITextComponent>(1);
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.flow_limiter.mode", new Object[]{LIMITS[this.limitIndex]}));
        CRPackets.sendPacketToPlayer(player, new SendChatToClient(chat, 25856));
    }

    @Override
    protected void performTransfer() {
        LazyOptional otherOpt;
        Direction side = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)ESProperties.FACING);
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (this.contents.getTotalQty() == 0 || te == null || !(otherOpt = te.getCapability(Capabilities.CHEMICAL_CAPABILITY, side.func_176734_d())).isPresent()) {
            return;
        }
        IChemicalHandler otherHandler = (IChemicalHandler)otherOpt.orElseThrow(NullPointerException::new);
        EnumContainerType cont = otherHandler.getChannel(side.func_176734_d());
        if (cont != EnumContainerType.NONE && cont == EnumContainerType.GLASS != this.glass) {
            return;
        }
        int limit = LIMITS[this.limitIndex];
        ReagentMap transferReag = new ReagentMap();
        for (IReagent type : this.contents.keySet()) {
            int qty = this.contents.getQty(type);
            int specificLimit = Math.min(qty, limit - otherHandler.getContent(type));
            if (specificLimit <= 0) continue;
            transferReag.transferReagent(type, specificLimit, this.contents);
        }
        boolean changed = otherHandler.insertReagents(transferReag, side.func_176734_d(), this.handler);
        for (IReagent type : transferReag.keySet()) {
            this.contents.transferReagent(type, transferReag.getQty(type), transferReag);
        }
        if (changed) {
            this.correctReag();
            this.func_70296_d();
        }
    }

    @Override
    protected EnumTransferMode[] getModes() {
        EnumTransferMode[] output = new EnumTransferMode[]{EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE};
        Direction outSide = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)ESProperties.FACING);
        output[outSide.func_176745_a()] = EnumTransferMode.OUTPUT;
        output[outSide.func_176734_d().func_176745_a()] = EnumTransferMode.INPUT;
        return output;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.limitIndex = Math.min(nbt.func_74762_e("limit"), LIMITS.length - 1);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("limit", this.limitIndex);
        return nbt;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CHEMICAL_CAPABILITY && (side == null || side.func_176740_k() == ((Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)ESProperties.FACING)).func_176740_k())) {
            return this.chemOpt;
        }
        return super.getCapability(cap, side);
    }
}

