/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyReactorTE;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyUtil;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import com.Da_Technomancer.crossroads.blocks.alchemy.GlasswareHolder;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.alchemy.AbstractGlassware;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class GlasswareHolderTileEntity
extends AlchemyReactorTE {
    @ObjectHolder(value="glassware_holder")
    private static TileEntityType<GlasswareHolderTileEntity> type = null;
    protected AbstractGlassware.GlasswareTypes glassType = null;
    private LazyOptional<IHeatHandler> heatOpt = LazyOptional.of(() -> new HeatHandler());

    public GlasswareHolderTileEntity() {
        this((TileEntityType<? extends GlasswareHolderTileEntity>)type);
    }

    protected GlasswareHolderTileEntity(TileEntityType<? extends GlasswareHolderTileEntity> type) {
        super((TileEntityType<? extends AlchemyReactorTE>)type);
    }

    private AbstractGlassware.GlasswareTypes heldType() {
        if (this.glassType == null) {
            BlockState state = this.func_195044_w();
            if (state.func_235901_b_(CRProperties.CONTAINER_TYPE)) {
                this.glassType = (AbstractGlassware.GlasswareTypes)((Object)state.func_177229_b(CRProperties.CONTAINER_TYPE));
                return this.glassType;
            }
            return AbstractGlassware.GlasswareTypes.NONE;
        }
        return this.glassType;
    }

    @Override
    protected boolean useCableHeat() {
        return true;
    }

    @Override
    protected void initHeat() {
        if (!this.init) {
            this.init = true;
            this.cableTemp = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected int transferCapacity() {
        return this.heldType().capacity;
    }

    private ItemStack getStoredItem(BlockState state) {
        ItemStack out;
        AbstractGlassware.GlasswareTypes heldType = (AbstractGlassware.GlasswareTypes)((Object)state.func_177229_b(CRProperties.CONTAINER_TYPE));
        if (heldType == AbstractGlassware.GlasswareTypes.NONE) {
            return ItemStack.field_190927_a;
        }
        boolean crystal = (Boolean)state.func_177229_b((Property)CRProperties.CRYSTAL);
        switch (heldType) {
            case PHIAL: {
                out = crystal ? new ItemStack((IItemProvider)CRItems.phialCrystal, 1) : new ItemStack((IItemProvider)CRItems.phialGlass, 1);
                break;
            }
            case FLORENCE: {
                out = crystal ? new ItemStack((IItemProvider)CRItems.florenceFlaskCrystal, 1) : new ItemStack((IItemProvider)CRItems.florenceFlaskGlass, 1);
                break;
            }
            case SHELL: {
                out = crystal ? new ItemStack((IItemProvider)CRItems.shellCrystal, 1) : new ItemStack((IItemProvider)CRItems.shellGlass, 1);
                break;
            }
            default: {
                return ItemStack.field_190927_a;
            }
        }
        ((AbstractGlassware)out.func_77973_b()).setReagents(out, this.contents);
        return out;
    }

    @Override
    protected void destroyCarrier(float strength) {
        BlockState state = this.func_195044_w();
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)state.func_206870_a((Property)CRProperties.CRYSTAL, (Comparable)Boolean.valueOf(false))).func_206870_a(CRProperties.CONTAINER_TYPE, (Comparable)((Object)AbstractGlassware.GlasswareTypes.NONE)));
        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundType.field_185853_f.func_185845_c(), SoundCategory.BLOCKS, SoundType.field_185853_f.func_185843_a(), SoundType.field_185853_f.func_185847_b());
        this.glassType = null;
        this.dirtyReag = true;
        AlchemyUtil.releaseChemical(this.field_145850_b, this.field_174879_c, this.contents);
        this.contents = new ReagentMap();
        if (strength > 0.0f) {
            this.field_145850_b.func_217385_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), strength, Explosion.Mode.BREAK);
        }
    }

    public void onBlockDestroyed(BlockState state) {
        if (state.func_177229_b(CRProperties.CONTAINER_TYPE) != AbstractGlassware.GlasswareTypes.NONE) {
            ItemStack out = this.getStoredItem(state);
            this.contents = new ReagentMap();
            this.dirtyReag = true;
            this.glassType = AbstractGlassware.GlasswareTypes.NONE;
            this.func_70296_d();
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)out);
        }
    }

    @Override
    @Nonnull
    public ItemStack rightClickWithItem(ItemStack stack, boolean sneaking, PlayerEntity player, Hand hand) {
        BlockState state = this.func_195044_w();
        if (this.heldType() != AbstractGlassware.GlasswareTypes.NONE) {
            if (stack.func_190926_b() && sneaking) {
                ItemStack out = this.getStoredItem(this.func_195044_w());
                this.glassType = null;
                this.contents.clear();
                this.dirtyReag = true;
                this.func_70296_d();
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)state.func_206870_a((Property)CRProperties.CRYSTAL, (Comparable)Boolean.valueOf(false))).func_206870_a(CRProperties.CONTAINER_TYPE, (Comparable)((Object)AbstractGlassware.GlasswareTypes.NONE)));
                this.heatOpt.invalidate();
                this.heatOpt = LazyOptional.of(() -> new HeatHandler());
                return out;
            }
            return super.rightClickWithItem(stack, sneaking, player, hand);
        }
        if (stack.func_77973_b() instanceof AbstractGlassware) {
            this.contents = ((AbstractGlassware)stack.func_77973_b()).getReagants(stack);
            this.glass = !((AbstractGlassware)stack.func_77973_b()).isCrystal();
            this.dirtyReag = true;
            this.func_70296_d();
            this.glassType = null;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)((BlockState)state.func_206870_a((Property)CRProperties.CRYSTAL, (Comparable)Boolean.valueOf(!this.glass))).func_206870_a(CRProperties.CONTAINER_TYPE, (Comparable)((Object)((AbstractGlassware)stack.func_77973_b()).containerType())));
            if (this.contents.getTotalQty() > 0) {
                this.cableTemp = this.contents.getTempC();
            }
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    @Override
    protected Vector3d getParticlePos() {
        return Vector3d.func_237491_b_((Vector3i)this.field_174879_c).func_72441_c(0.5, 0.25, 0.5);
    }

    @Override
    protected double correctTemp() {
        if (this.heldType().connectToCable) {
            return super.correctTemp();
        }
        return this.contents.getTempC();
    }

    @Override
    protected void performTransfer() {
        BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() instanceof GlasswareHolder && this.heldType() != AbstractGlassware.GlasswareTypes.NONE) {
            LazyOptional otherOpt;
            Direction side = Direction.UP;
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (this.contents.getTotalQty() == 0 || te == null || !(otherOpt = te.getCapability(Capabilities.CHEMICAL_CAPABILITY, side.func_176734_d())).isPresent()) {
                return;
            }
            IChemicalHandler otherHandler = (IChemicalHandler)otherOpt.orElseThrow(NullPointerException::new);
            EnumContainerType cont = otherHandler.getChannel(side.func_176734_d());
            if (cont != EnumContainerType.NONE && cont == EnumContainerType.GLASS != this.glass) {
                return;
            }
            if (otherHandler.insertReagents(this.contents, side.func_176734_d(), this.handler, state.func_235901_b_((Property)ESProperties.REDSTONE_BOOL) && (Boolean)state.func_177229_b((Property)ESProperties.REDSTONE_BOOL) != false)) {
                this.correctReag();
                this.func_70296_d();
            }
        }
    }

    @Override
    protected EnumTransferMode[] getModes() {
        EnumTransferMode[] modes = new EnumTransferMode[]{EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE, EnumTransferMode.NONE};
        if (this.heldType() != AbstractGlassware.GlasswareTypes.NONE) {
            modes[1] = EnumTransferMode.BOTH;
        }
        return modes;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.heatOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if ((side == null || side == Direction.UP) && cap == Capabilities.CHEMICAL_CAPABILITY && this.heldType() != AbstractGlassware.GlasswareTypes.NONE) {
            return this.chemOpt;
        }
        if ((side == null || side == Direction.DOWN) && cap == Capabilities.HEAT_CAPABILITY && this.heldType().connectToCable) {
            return this.heatOpt;
        }
        return super.getCapability(cap, side);
    }

    private class HeatHandler
    implements IHeatHandler {
        private HeatHandler() {
        }

        @Override
        public double getTemp() {
            GlasswareHolderTileEntity.this.initHeat();
            return GlasswareHolderTileEntity.this.cableTemp;
        }

        @Override
        public void setTemp(double tempIn) {
            GlasswareHolderTileEntity.this.init = true;
            GlasswareHolderTileEntity.this.cableTemp = tempIn;
            GlasswareHolderTileEntity.this.dirtyReag = true;
            GlasswareHolderTileEntity.this.func_70296_d();
        }

        @Override
        public void addHeat(double tempChange) {
            GlasswareHolderTileEntity.this.initHeat();
            GlasswareHolderTileEntity.this.cableTemp += tempChange;
            GlasswareHolderTileEntity.this.dirtyReag = true;
            GlasswareHolderTileEntity.this.func_70296_d();
        }
    }
}

