/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import com.Da_Technomancer.crossroads.gui.container.HeatLimiterContainer;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.Da_Technomancer.essentials.packets.INBTReceiver;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class HeatLimiterBasicTileEntity
extends TileEntity
implements ITickableTileEntity,
IInfoTE,
INamedContainerProvider,
INBTReceiver {
    @ObjectHolder(value="heat_limiter_basic")
    private static TileEntityType<HeatLimiterBasicTileEntity> type = null;
    private double heatIn = 0.0;
    private double heatOut = 0.0;
    private boolean init = false;
    public float setting = 0.0f;
    public String expression = "0";
    private final LazyOptional<IHeatHandler> heatInOpt = LazyOptional.of(() -> new HeatHandler(true));
    private final LazyOptional<IHeatHandler> heatOutOpt = LazyOptional.of(() -> new HeatHandler(false));

    public HeatLimiterBasicTileEntity() {
        super(type);
    }

    protected HeatLimiterBasicTileEntity(TileEntityType<? extends HeatLimiterBasicTileEntity> type) {
        super(type);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        this.init();
        HeatUtil.addHeatInfo(chat, this.heatIn, -32768.0);
        HeatUtil.addHeatInfo(chat, this.heatOut, HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c));
    }

    protected double getSetting() {
        return this.setting;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.init) {
            this.init();
        }
        double goalTemp = HeatUtil.toCelcius(this.getSetting());
        boolean blueMode = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)CRProperties.ACTIVE);
        if (blueMode) {
            this.heatIn = -this.heatIn;
            this.heatOut = -this.heatOut;
            goalTemp = -goalTemp;
        }
        if (this.heatOut > goalTemp) {
            if (this.heatIn < goalTemp) {
                double toTrans = goalTemp - this.heatOut;
                toTrans = Math.max(toTrans, this.heatIn - goalTemp);
                this.heatOut += toTrans;
                this.heatIn -= toTrans;
                this.func_70296_d();
            } else {
                double toTrans = this.heatIn - this.heatOut;
                toTrans /= 2.0;
                toTrans = Math.min(0.0, toTrans);
                this.heatOut += toTrans;
                this.heatIn -= toTrans;
                this.func_70296_d();
            }
        } else if (this.heatIn > goalTemp) {
            double toTrans = goalTemp - this.heatOut;
            toTrans = Math.min(toTrans, this.heatIn - goalTemp);
            this.heatOut += toTrans;
            this.heatIn -= toTrans;
            this.func_70296_d();
        } else {
            double toTrans = this.heatIn - this.heatOut;
            toTrans /= 2.0;
            toTrans = Math.max(0.0, toTrans);
            this.heatOut += toTrans;
            this.heatIn -= toTrans;
            this.func_70296_d();
        }
        if (blueMode) {
            this.heatIn = -this.heatIn;
            this.heatOut = -this.heatOut;
        }
    }

    private void init() {
        if (!this.init) {
            this.init = true;
            this.heatIn = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
            this.heatOut = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
            this.func_70296_d();
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("init_heat", this.init);
        nbt.func_74780_a("heat_in", this.heatIn);
        nbt.func_74780_a("heat_out", this.heatOut);
        nbt.func_74776_a("setting", this.setting);
        nbt.func_74778_a("expression", this.expression);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.init = nbt.func_74767_n("init_heat");
        this.heatIn = nbt.func_74769_h("heat_in");
        this.heatOut = nbt.func_74769_h("heat_out");
        this.setting = nbt.func_74760_g("setting");
        this.expression = nbt.func_74779_i("expression");
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.heatInOpt.invalidate();
        this.heatOutOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        Direction facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)ESProperties.FACING);
        if (cap == Capabilities.HEAT_CAPABILITY) {
            if (side == null || side == facing.func_176734_d()) {
                return this.heatInOpt;
            }
            if (side == facing) {
                return this.heatOutOpt;
            }
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.heat_limiter");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new HeatLimiterContainer(id, playerInv, this.setting, this.expression, this.field_174879_c);
    }

    public void receiveNBT(CompoundNBT nbt, @Nullable ServerPlayerEntity player) {
        if (nbt.func_74764_b("value")) {
            this.setting = nbt.func_74760_g("value");
            this.expression = nbt.func_74779_i("config");
            this.func_70296_d();
        }
    }

    private class HeatHandler
    implements IHeatHandler {
        private final boolean in;

        private HeatHandler(boolean in) {
            this.in = in;
        }

        @Override
        public double getTemp() {
            HeatLimiterBasicTileEntity.this.init();
            return this.in ? HeatLimiterBasicTileEntity.this.heatIn : HeatLimiterBasicTileEntity.this.heatOut;
        }

        @Override
        public void setTemp(double tempIn) {
            HeatLimiterBasicTileEntity.this.init = true;
            if (this.in) {
                HeatLimiterBasicTileEntity.this.heatIn = tempIn;
            } else {
                HeatLimiterBasicTileEntity.this.heatOut = tempIn;
            }
            HeatLimiterBasicTileEntity.this.func_70296_d();
        }

        @Override
        public void addHeat(double heatChange) {
            HeatLimiterBasicTileEntity.this.init();
            if (this.in) {
                HeatLimiterBasicTileEntity.this.heatIn += heatChange;
            } else {
                HeatLimiterBasicTileEntity.this.heatOut += heatChange;
            }
            HeatLimiterBasicTileEntity.this.func_70296_d();
        }
    }
}

