/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.alchemy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyCarrierTE;
import com.Da_Technomancer.crossroads.API.alchemy.AlchemyReactorTE;
import com.Da_Technomancer.crossroads.API.alchemy.EnumContainerType;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.alchemy.IChemicalHandler;
import com.Da_Technomancer.crossroads.API.alchemy.ReagentMap;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import com.Da_Technomancer.crossroads.blocks.alchemy.ReactionChamber;
import com.Da_Technomancer.crossroads.render.CRRenderUtil;
import com.Da_Technomancer.crossroads.tileentities.electric.TeslaCoilTopTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class ReactionChamberTileEntity
extends AlchemyReactorTE {
    @ObjectHolder(value="reaction_chamber")
    private static TileEntityType<ReactionChamberTileEntity> type = null;
    private int energy = 0;
    private static final int ENERGY_CAPACITY = 20;
    public static final int DRAIN = 10;
    private final LazyOptional<IHeatHandler> heatOpt = LazyOptional.of(() -> new HeatHandler());
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new AlchemyCarrierTE.ItemHandler());
    private final LazyOptional<IEnergyStorage> energyOpt = LazyOptional.of(() -> new EnergyHandler());

    public ReactionChamberTileEntity() {
        super((TileEntityType<? extends AlchemyReactorTE>)type);
    }

    public ReactionChamberTileEntity(boolean glass) {
        super((TileEntityType<? extends AlchemyReactorTE>)type, glass);
    }

    @Override
    protected void initHeat() {
        if (!this.init) {
            this.init = true;
            this.cableTemp = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
        }
    }

    public ReagentMap getMap() {
        return this.contents;
    }

    public void writeContentNBT(ItemStack stack) {
        this.contents = ReactionChamber.getReagants(stack);
        this.dirtyReag = true;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.energy >= 10) {
            this.energy -= 10;
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                CRRenderUtil.addArc(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 0.5f, (float)this.field_174879_c.func_177952_p() + 0.5f, (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat(), (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat(), 1, 0.0f, TeslaCoilTopTileEntity.COLOR_CODES[(int)(this.field_145850_b.func_82737_E() % 3L)]);
            }
        }
        super.func_73660_a();
    }

    @Override
    public boolean isCharged() {
        return this.energy >= 10 || super.isCharged();
    }

    @Override
    public int transferCapacity() {
        return 200;
    }

    @Override
    protected boolean useCableHeat() {
        return true;
    }

    @Override
    protected EnumTransferMode[] getModes() {
        return new EnumTransferMode[]{EnumTransferMode.BOTH, EnumTransferMode.BOTH, EnumTransferMode.BOTH, EnumTransferMode.BOTH, EnumTransferMode.BOTH, EnumTransferMode.BOTH};
    }

    @Override
    protected void performTransfer() {
        EnumTransferMode[] modes = this.getModes();
        for (int i = 0; i < 6; ++i) {
            LazyOptional otherOpt;
            if (!modes[i].isOutput()) continue;
            Direction side = Direction.func_82600_a((int)i);
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
            if (this.contents.getTotalQty() <= 0 || te == null || !(otherOpt = te.getCapability(Capabilities.CHEMICAL_CAPABILITY, side.func_176734_d())).isPresent()) continue;
            IChemicalHandler otherHandler = (IChemicalHandler)otherOpt.orElseThrow(NullPointerException::new);
            EnumContainerType cont = otherHandler.getChannel(side.func_176734_d());
            if (otherHandler.getMode(side.func_176734_d()) == EnumTransferMode.BOTH && modes[i] == EnumTransferMode.BOTH || this.contents.getTotalQty() == 0 || !otherHandler.insertReagents(this.contents, side.func_176734_d(), this.handler)) continue;
            this.correctReag();
            this.func_70296_d();
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.energy = nbt.func_74762_e("ener");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("ener", this.energy);
        return nbt;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.heatOpt.invalidate();
        this.itemOpt.invalidate();
        this.energyOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.CHEMICAL_CAPABILITY) {
            return this.chemOpt;
        }
        if (cap == Capabilities.HEAT_CAPABILITY) {
            return this.heatOpt;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        if (cap == CapabilityEnergy.ENERGY && (side == null || side.func_176740_k() != Direction.Axis.Y)) {
            return this.energyOpt;
        }
        return super.getCapability(cap, side);
    }

    private class HeatHandler
    implements IHeatHandler {
        private HeatHandler() {
        }

        @Override
        public double getTemp() {
            ReactionChamberTileEntity.this.initHeat();
            return ReactionChamberTileEntity.this.cableTemp;
        }

        @Override
        public void setTemp(double tempIn) {
            ReactionChamberTileEntity.this.init = true;
            ReactionChamberTileEntity.this.cableTemp = tempIn;
            ReactionChamberTileEntity.this.dirtyReag = true;
            ReactionChamberTileEntity.this.func_70296_d();
        }

        @Override
        public void addHeat(double tempChange) {
            ReactionChamberTileEntity.this.initHeat();
            ReactionChamberTileEntity.this.cableTemp += tempChange;
            ReactionChamberTileEntity.this.dirtyReag = true;
            ReactionChamberTileEntity.this.func_70296_d();
        }
    }

    private class EnergyHandler
    implements IEnergyStorage {
        private EnergyHandler() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int toMove = Math.min(20 - ReactionChamberTileEntity.this.energy, maxReceive);
            if (!simulate && toMove > 0) {
                ReactionChamberTileEntity.this.energy += toMove;
                ReactionChamberTileEntity.this.func_70296_d();
            }
            return toMove;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return ReactionChamberTileEntity.this.energy;
        }

        public int getMaxEnergyStored() {
            return 20;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

