/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.electric;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.IIntReceiver;
import com.Da_Technomancer.crossroads.API.packets.SendIntToClient;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.blocks.electric.TeslaCoilTop;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.LeydenJar;
import com.Da_Technomancer.crossroads.tileentities.electric.TeslaCoilTopTileEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class TeslaCoilTileEntity
extends TileEntity
implements ITickableTileEntity,
IIntReceiver {
    @ObjectHolder(value="tesla_coil")
    private static TileEntityType<TeslaCoilTileEntity> type = null;
    public static final int CAPACITY = 2000;
    private int stored = 0;
    private Boolean hasJar = null;
    public boolean redstone = false;
    private LazyOptional<IEnergyStorage> optIn = LazyOptional.of(() -> new EnergyHandlerIn());
    private LazyOptional<IEnergyStorage> optOut = LazyOptional.of(() -> new EnergyHandlerOut());

    public TeslaCoilTileEntity() {
        super(type);
    }

    public void syncState() {
        int message = 0;
        if (this.redstone) {
            message |= 1;
        }
        CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, new SendIntToClient(0, message |= this.stored << 1, this.field_174879_c));
    }

    public void setStored(int storedIn) {
        int prev = this.stored;
        this.stored = storedIn;
        if (!this.field_145850_b.field_72995_K && prev >= TeslaCoilTop.TeslaCoilVariants.DECORATIVE.joltAmt ^ storedIn >= TeslaCoilTop.TeslaCoilVariants.DECORATIVE.joltAmt) {
            this.syncState();
        }
        this.func_70296_d();
    }

    public int getStored() {
        return this.stored;
    }

    public int getCapacity() {
        return this.hasJar() ? 102000 : 2000;
    }

    @Override
    public void receiveInt(byte identifier, int message, @Nullable ServerPlayerEntity sendingPlayer) {
        if (identifier == 0) {
            this.redstone = (message & 1) == 1;
            this.stored = message >>> 1;
        }
    }

    private boolean hasJar() {
        if (this.hasJar == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() != CRBlocks.teslaCoil) {
                this.func_145843_s();
                return false;
            }
            this.hasJar = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)CRProperties.ACTIVE);
        }
        return this.hasJar;
    }

    public void func_73660_a() {
        IEnergyStorage storage;
        int moved;
        LazyOptional energyOpt;
        Direction facing;
        TileEntity te;
        TileEntity topTE;
        if (!this.redstone && this.field_145850_b.func_82737_E() % 10L == 0L && this.stored > 0 && (topTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a())) instanceof TeslaCoilTopTileEntity) {
            ((TeslaCoilTopTileEntity)topTE).jolt(this);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.redstone && this.stored > 0 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing = (Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)CRProperties.HORIZ_FACING)))) != null && (energyOpt = te.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).isPresent() && (moved = (storage = (IEnergyStorage)energyOpt.orElseThrow(NullPointerException::new)).receiveEnergy(this.stored, false)) > 0) {
            this.setStored(this.getStored() - moved);
            this.func_70296_d();
        }
    }

    public void addJar(ItemStack stack) {
        this.setStored(Math.min(this.stored + LeydenJar.getCharge(stack), 102000));
        this.hasJar = true;
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("stored", this.stored);
        nbt.func_74757_a("reds", this.redstone);
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.stored = nbt.func_74762_e("stored");
        this.redstone = nbt.func_74767_n("reds");
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74768_a("stored", this.stored);
        nbt.func_74757_a("reds", this.redstone);
        return nbt;
    }

    @Nonnull
    public ItemStack removeJar() {
        ItemStack out = new ItemStack((IItemProvider)CRItems.leydenJar, 1);
        LeydenJar.setCharge(out, Math.min(this.stored, 100000));
        this.setStored(this.stored - Math.min(this.stored, 100000));
        this.hasJar = false;
        this.func_70296_d();
        return out;
    }

    public void rotate() {
        this.optIn.invalidate();
        this.optIn = LazyOptional.of(() -> new EnergyHandlerIn());
        this.optOut.invalidate();
        this.optOut = LazyOptional.of(() -> new EnergyHandlerOut());
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.optIn.invalidate();
        this.optOut.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return side == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)CRProperties.HORIZ_FACING) ? this.optOut : this.optIn;
        }
        return super.getCapability(cap, side);
    }

    private class EnergyHandlerOut
    implements IEnergyStorage {
        private EnergyHandlerOut() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return 0;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int toExtract = Math.min(TeslaCoilTileEntity.this.stored, maxExtract);
            if (!simulate) {
                TeslaCoilTileEntity.this.setStored(TeslaCoilTileEntity.this.stored - toExtract);
                TeslaCoilTileEntity.this.func_70296_d();
            }
            return toExtract;
        }

        public int getEnergyStored() {
            return TeslaCoilTileEntity.this.stored;
        }

        public int getMaxEnergyStored() {
            return TeslaCoilTileEntity.this.getCapacity();
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return false;
        }
    }

    protected class EnergyHandlerIn
    implements IEnergyStorage {
        protected EnergyHandlerIn() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int toInsert = Math.min(maxReceive, this.getMaxEnergyStored() - TeslaCoilTileEntity.this.stored);
            if (!simulate) {
                TeslaCoilTileEntity.this.setStored(TeslaCoilTileEntity.this.stored + toInsert);
                TeslaCoilTileEntity.this.func_70296_d();
            }
            return toInsert;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return TeslaCoilTileEntity.this.stored;
        }

        public int getMaxEnergyStored() {
            return TeslaCoilTileEntity.this.hasJar() ? 102000 : 2000;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

