/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.container.FatCollectorContainer;
import com.Da_Technomancer.crossroads.items.CRItems;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FatCollectorTileEntity
extends InventoryTE {
    @ObjectHolder(value="fat_collector")
    private static TileEntityType<FatCollectorTileEntity> type = null;
    public static final int[] TIERS = new int[]{100, 120, 140, 160, 180, 200};
    public static final double[] EFFICIENCY = new double[]{0.8, 1.0, 1.2, 1.0, 0.8, 0.0};
    private static final double USE_PER_VALUE = 2.0;
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());

    public FatCollectorTileEntity() {
        super(type, 1);
        this.fluidProps[0] = new ModuleTE.TankProperty(8000, false, true);
        this.initFluidManagers();
    }

    @Override
    public int fluidTanks() {
        return 1;
    }

    @Override
    public boolean useHeat() {
        return true;
    }

    @Override
    public void func_73660_a() {
        Food food;
        super.func_73660_a();
        int tier = HeatUtil.getHeatTier(this.temp, TIERS);
        if (tier != -1 && !this.inventory[0].func_190926_b() && (food = this.inventory[0].func_77973_b().func_219967_s()) != null) {
            int liqAm = Math.min(food.func_221466_a() + (int)((float)food.func_221466_a() * food.func_221469_b() * 2.0f), this.fluidProps[0].capacity);
            double heatUse = (double)liqAm * 2.0;
            liqAm *= 100;
            if ((liqAm = (int)((double)liqAm * EFFICIENCY[tier])) <= this.fluidProps[0].capacity - this.fluids[0].getAmount()) {
                this.temp -= heatUse;
                this.inventory[0].func_190918_g(1);
                if (this.fluids[0].isEmpty()) {
                    this.fluids[0] = new FluidStack((Fluid)CRFluids.liquidFat.still, liqAm);
                } else {
                    this.fluids[0].grow(liqAm);
                }
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != Direction.DOWN && facing != Direction.UP) {
            return this.globalFluidOpt;
        }
        if (capability == Capabilities.HEAT_CAPABILITY && (facing == null || facing == Direction.DOWN)) {
            return this.heatOpt;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b() != CRItems.edibleBlob;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.fat_collector");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new FatCollectorContainer(id, playerInv, this.createContainerBuf());
    }
}

