/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.container.FatFeederContainer;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class FatFeederTileEntity
extends InventoryTE {
    @ObjectHolder(value="fat_feeder")
    private static TileEntityType<FatFeederTileEntity> type = null;
    private static final int BREED_AMOUNT = 200;
    public static final int MIN_RANGE = 4;
    public static final int MAX_RANGE = 16;

    public FatFeederTileEntity() {
        super(type, 0);
        this.fluidProps[0] = new ModuleTE.TankProperty(10000, true, true, f -> f == CRFluids.liquidFat.still);
        this.initFluidManagers();
    }

    @Override
    protected int fluidTanks() {
        return 1;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        float range = (float)Math.abs(this.fluids[0].getAmount() - this.fluidProps[0].capacity / 2) / (float)(this.fluidProps[0].capacity / 2);
        range = (1.0f - range) * 12.0f + 4.0f;
        List players = this.field_145850_b.func_175647_a(PlayerEntity.class, new AxisAlignedBB(this.field_174879_c.func_177973_b(new Vector3i((double)range, (double)range, (double)range)), this.field_174879_c.func_177971_a(new Vector3i((double)range, (double)range, (double)range))), EntityPredicates.field_94557_a);
        for (PlayerEntity play : players) {
            FoodStats food = play.func_71024_bL();
            int added = Math.min(this.fluids[0].getAmount() / 100, 40 - (food.func_75116_a() + (int)food.func_75115_e()));
            if (added < 4) continue;
            this.fluids[0].shrink(added * 100);
            int hungerAdded = Math.min(20 - food.func_75116_a(), added);
            CompoundNBT nbt = new CompoundNBT();
            food.func_75117_b(nbt);
            nbt.func_74768_a("foodLevel", hungerAdded + food.func_75116_a());
            nbt.func_74776_a("foodSaturationLevel", Math.min(20.0f - food.func_75115_e(), (float)(added - hungerAdded)) + food.func_75115_e());
            food.func_75112_a(nbt);
            this.func_70296_d();
        }
        if (this.fluids[0].getAmount() < 200) {
            return;
        }
        List animals = this.field_145850_b.func_175647_a(AgeableEntity.class, new AxisAlignedBB(this.field_174879_c.func_177973_b(new Vector3i((double)range, (double)range, (double)range)), this.field_174879_c.func_177971_a(new Vector3i((double)range, (double)range, (double)range))), EntityPredicates.field_94557_a);
        if (animals.size() >= 64) {
            return;
        }
        boolean canBreedVillagers = Tags.Blocks.STORAGE_BLOCKS_EMERALD.func_230235_a_((Object)this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c());
        for (AgeableEntity ent : animals) {
            if (ent instanceof AnimalEntity) {
                AnimalEntity anim = (AnimalEntity)ent;
                if (this.fluids[0].getAmount() < 200 || anim.func_70874_b() != 0 || anim.func_70880_s()) continue;
                anim.func_146082_f(null);
                this.fluids[0].shrink(200);
                this.func_70296_d();
                continue;
            }
            if (!(ent instanceof VillagerEntity) || !canBreedVillagers) continue;
            VillagerEntity vill = (VillagerEntity)ent;
            if (this.fluids[0].getAmount() < 200 || vill.func_70874_b() != 0 || vill.func_70874_b() != 0 || vill.func_213743_em()) continue;
            CompoundNBT villNBT = new CompoundNBT();
            vill.func_213281_b(villNBT);
            villNBT.func_74774_a("FoodLevel", (byte)(villNBT.func_74771_c("FoodLevel") + 12));
            vill.func_70037_a(villNBT);
            this.fluids[0].shrink(200);
            this.func_70296_d();
        }
    }

    @Override
    protected IFluidHandler createGlobalFluidHandler() {
        return new ModuleTE.FluidTankHandler(0);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.globalFluidOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.fat_feeder");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new FatFeederContainer(id, playerInv, this.createContainerBuf());
    }
}

