/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.container.OreCleanserContainer;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.OreCleanserRec;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class OreCleanserTileEntity
extends InventoryTE {
    @ObjectHolder(value="ore_cleanser")
    private static TileEntityType<OreCleanserTileEntity> type = null;
    public static final int WATER_USE = 250;
    private int progress = 0;
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());
    private final LazyOptional<IFluidHandler> inOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(0));
    private final LazyOptional<IFluidHandler> outOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(1));

    public OreCleanserTileEntity() {
        super(type, 2);
        this.fluidProps[0] = new ModuleTE.TankProperty(1000, true, false, f -> f == CRFluids.steam.still);
        this.fluidProps[1] = new ModuleTE.TankProperty(1000, false, true);
        this.initFluidManagers();
    }

    @Override
    public int fluidTanks() {
        return 2;
    }

    public int getProgress() {
        return Math.min(this.progress, 50);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.fluids[0].getAmount() >= 250 && this.fluidProps[1].capacity - this.fluids[1].getAmount() >= 250 && !this.inventory[0].func_190926_b()) {
            ItemStack created;
            Optional rec = this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.ORE_CLEANSER_TYPE, (IInventory)this, this.field_145850_b);
            if (!rec.isPresent()) {
                created = this.inventory[0].func_77946_l();
                created.func_190920_e(1);
            } else {
                created = ((OreCleanserRec)rec.get()).func_77572_b(this).func_77946_l();
            }
            if (!(this.inventory[1].func_190926_b() || this.inventory[1].func_77976_d() - this.inventory[1].func_190916_E() >= created.func_190916_E() && BlockUtil.sameItem((ItemStack)created, (ItemStack)this.inventory[1]))) {
                return;
            }
            ++this.progress;
            this.func_70296_d();
            if (this.progress < 50) {
                return;
            }
            this.fluids[0].shrink(250);
            if (this.fluids[1].isEmpty()) {
                this.fluids[1] = new FluidStack((Fluid)CRFluids.dirtyWater.still, 250);
            } else {
                this.fluids[1].grow(250);
            }
            this.inventory[0].func_190918_g(1);
            if (this.inventory[1].func_190926_b()) {
                this.inventory[1] = created;
            } else {
                this.inventory[1].func_190917_f(created.func_190916_E());
            }
        } else {
            this.progress = 0;
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.progress = nbt.func_74762_e("prog");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("prog", this.progress);
        return nbt;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
        this.inOpt.invalidate();
        this.outOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return facing == null ? this.globalFluidOpt : (facing == Direction.UP ? this.outOpt : this.inOpt);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.ORE_CLEANSER_TYPE, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b).isPresent();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.ore_cleanser");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new OreCleanserContainer(id, playerInv, this.createContainerBuf());
    }
}

