/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.container.RadiatorContainer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class RadiatorTileEntity
extends InventoryTE {
    @ObjectHolder(value="radiator")
    private static TileEntityType<RadiatorTileEntity> type = null;
    public static final int FLUID_USE = 100;
    private final LazyOptional<IFluidHandler> steamOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(0));
    private final LazyOptional<IFluidHandler> waterOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(1));

    public RadiatorTileEntity() {
        super(type, 0);
        this.fluidProps[0] = new ModuleTE.TankProperty(10000, true, false, f -> f == CRFluids.steam.still);
        this.fluidProps[1] = new ModuleTE.TankProperty(10000, false, true);
        this.initFluidManagers();
    }

    @Override
    public int fluidTanks() {
        return 2;
    }

    @Override
    public boolean useHeat() {
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.fluids[0].getAmount() >= 100 && this.fluidProps[1].capacity - this.fluids[1].getAmount() >= 100) {
            this.temp += 100.0 * (double)((Integer)CRConfig.steamWorth.get()).intValue() / 1000.0;
            if (this.fluids[1].isEmpty()) {
                this.fluids[1] = new FluidStack((Fluid)CRFluids.distilledWater.still, 100);
            } else {
                this.fluids[1].grow(100);
            }
            this.fluids[0].shrink(100);
            this.func_70296_d();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.steamOpt.invalidate();
        this.waterOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == Direction.UP) {
                return this.waterOpt;
            }
            if (side == Direction.DOWN) {
                return this.steamOpt;
            }
        }
        if (cap == Capabilities.HEAT_CAPABILITY && side != Direction.UP && side != Direction.DOWN) {
            return this.heatOpt;
        }
        return super.getCapability(cap, side);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.radiator");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new RadiatorContainer(id, playerInventory, this.createContainerBuf());
    }
}

