/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.container.SteamBoilerContainer;
import com.Da_Technomancer.crossroads.items.CRItems;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class SteamBoilerTileEntity
extends InventoryTE {
    @ObjectHolder(value="steam_boiler")
    private static TileEntityType<SteamBoilerTileEntity> type = null;
    public static final int BATCH_SIZE = 100;
    public static final int[] TIERS = new int[]{100, 200, 300, 400, 500};
    private final LazyOptional<IFluidHandler> waterOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(0));
    private final LazyOptional<IFluidHandler> steamOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(1));

    public SteamBoilerTileEntity() {
        super(type, 1);
        this.fluidProps[0] = new ModuleTE.TankProperty(8000, true, false, f -> f == Fluids.field_204546_a || f == CRFluids.distilledWater.still);
        this.fluidProps[1] = new ModuleTE.TankProperty(8000, false, true, fluid -> true);
        this.initFluidManagers();
    }

    @Override
    public int fluidTanks() {
        return 2;
    }

    @Override
    public boolean useHeat() {
        return true;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        super.addInfo(chat, player, hit);
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.steam_boiler.salt", new Object[]{this.inventory[0].func_190916_E()}));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int tier = HeatUtil.getHeatTier(this.temp, TIERS);
        if (tier != -1) {
            this.temp -= (double)((Integer)CRConfig.steamWorth.get()).intValue() * (double)(tier + 1) * 100.0 / 1000.0;
            int fluidCap = this.fluidProps[0].capacity;
            if (this.fluids[0].getAmount() >= 100 && fluidCap - this.fluids[1].getAmount() >= 100 && this.inventory[0].func_190916_E() < 64) {
                boolean salty = this.fluids[0].getFluid() == Fluids.field_204546_a;
                int batches = Math.min(tier + 1, this.fluids[0].getAmount() / 100);
                batches = Math.min(batches, (fluidCap - this.fluids[1].getAmount()) / 100);
                if (salty) {
                    batches = Math.min(batches, 64 - this.inventory[0].func_190916_E());
                }
                this.fluids[0].shrink(batches * 100);
                if (this.fluids[1].isEmpty()) {
                    this.fluids[1] = new FluidStack((Fluid)CRFluids.steam.still, 100 * batches);
                } else {
                    this.fluids[1].grow(100 * batches);
                }
                if (salty) {
                    if (this.inventory[0].func_190926_b()) {
                        this.inventory[0] = new ItemStack((IItemProvider)CRItems.dustSalt, batches);
                    } else {
                        this.inventory[0].func_190917_f(batches);
                    }
                }
            }
            this.func_70296_d();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.waterOpt.invalidate();
        this.steamOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == null) {
                return this.globalFluidOpt;
            }
            if (facing == Direction.UP) {
                return this.steamOpt;
            }
            return this.waterOpt;
        }
        if (capability == Capabilities.HEAT_CAPABILITY && (facing == null || facing == Direction.DOWN)) {
            return this.heatOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.steam_boiler");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new SteamBoilerContainer(i, playerInventory, this.createContainerBuf());
    }
}

