/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.container.SteamerContainer;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.SmokingRecipe;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class SteamerTileEntity
extends InventoryTE {
    @ObjectHolder(value="steamer")
    private static TileEntityType<SteamerTileEntity> type = null;
    public static final int FLUID_USE = 200;
    public static final int REQUIRED = 50;
    private int progress = 0;
    private final LazyOptional<IFluidHandler> steamOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(0));
    private final LazyOptional<IFluidHandler> waterOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(1));

    public SteamerTileEntity() {
        super(type, 2);
        this.fluidProps[0] = new ModuleTE.TankProperty(10000, true, false, f -> f == CRFluids.steam.still);
        this.fluidProps[1] = new ModuleTE.TankProperty(10000, false, true);
        this.initFluidManagers();
    }

    @Override
    public int fluidTanks() {
        return 2;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.progress", new Object[]{this.progress, 50}));
        super.addInfo(chat, player, hit);
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    public void func_73660_a() {
        SmokingRecipe rec;
        super.func_73660_a();
        if (!this.inventory[0].func_190926_b() && (rec = (SmokingRecipe)this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222152_d, (IInventory)this, this.field_145850_b).orElse(null)) != null && (this.inventory[1].func_190926_b() || BlockUtil.sameItem((ItemStack)rec.func_77571_b(), (ItemStack)this.inventory[1]) && this.inventory[1].func_190916_E() < this.inventory[1].func_77976_d())) {
            if (!this.field_145850_b.field_72995_K && this.fluids[0].getAmount() >= 200 && this.fluidProps[1].capacity - this.fluids[1].getAmount() >= 200) {
                if (this.fluids[1].isEmpty()) {
                    this.fluids[1] = new FluidStack((Fluid)CRFluids.distilledWater.still, 200);
                } else {
                    this.fluids[1].grow(200);
                }
                this.fluids[0].shrink(200);
                if (++this.progress >= 50) {
                    this.progress = 0;
                    if (this.inventory[1].func_190926_b()) {
                        this.inventory[1] = rec.func_77572_b((IInventory)this);
                    } else {
                        this.inventory[1].func_190917_f(1);
                    }
                    this.inventory[0].func_190918_g(1);
                }
                this.func_70296_d();
            }
        } else {
            this.progress = 0;
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && !stack.func_190926_b() && this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222152_d, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b).isPresent();
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.steamOpt.invalidate();
        this.waterOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == Direction.UP || side == Direction.DOWN) {
                return this.waterOpt;
            }
            if (side != null) {
                return this.steamOpt;
            }
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.steamer");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new SteamerContainer(id, playerInventory, this.createContainerBuf());
    }
}

