/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.fluid;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.gui.container.WaterCentrifugeContainer;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.CentrifugeRec;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class WaterCentrifugeTileEntity
extends InventoryTE {
    @ObjectHolder(value="water_centrifuge")
    private static TileEntityType<WaterCentrifugeTileEntity> type = null;
    public static final double TIP_POINT = 0.5;
    public static final int INERTIA = 50;
    private boolean neg;
    private LazyOptional<IFluidHandler> waterOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(0));
    private LazyOptional<IFluidHandler> dWaterOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(1));
    private final LazyOptional<IItemHandler> saltOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());

    public WaterCentrifugeTileEntity() {
        super(type, 1);
        this.fluidProps[0] = new ModuleTE.TankProperty(10000, true, false, f -> true);
        this.fluidProps[1] = new ModuleTE.TankProperty(10000, false, true, f -> false);
        this.initFluidManagers();
    }

    public boolean isNeg() {
        return this.neg;
    }

    @Override
    public int fluidTanks() {
        return 2;
    }

    public FluidStack getInputFluid() {
        return this.fluids[0];
    }

    @Override
    public boolean useRotary() {
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (Math.abs(this.motData[0]) >= 0.5 && Math.signum(this.motData[0]) == -1.0 == this.neg) {
            this.neg = !this.neg;
            Optional recOpt = this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.CENTRIFUGE_TYPE, (IInventory)this, this.field_145850_b);
            if (recOpt.isPresent()) {
                CentrifugeRec rec = (CentrifugeRec)recOpt.get();
                FluidStack fluidOut = rec.getFluidOutput();
                ItemStack itemOut = rec.func_77571_b();
                this.fluids[0].shrink(rec.getInput().getAmount());
                if (this.fluids[1].isEmpty()) {
                    this.fluids[1] = fluidOut.copy();
                } else if (BlockUtil.sameFluid((FluidStack)this.fluids[1], (FluidStack)fluidOut)) {
                    this.fluids[1].setAmount(Math.min(this.fluids[1].getAmount() + fluidOut.getAmount(), this.fluidProps[1].capacity));
                }
                if (this.inventory[0].func_190926_b()) {
                    this.inventory[0] = itemOut.func_77946_l();
                } else if (BlockUtil.sameItem((ItemStack)this.inventory[0], (ItemStack)itemOut)) {
                    this.inventory[0].func_190920_e(Math.min(this.inventory[0].func_190916_E() + itemOut.func_190916_E(), itemOut.func_77976_d()));
                }
                this.func_70296_d();
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("neg", this.neg);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.neg = nbt.func_74767_n("neg");
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.waterOpt.invalidate();
        this.dWaterOpt.invalidate();
        this.saltOpt.invalidate();
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.waterOpt.invalidate();
        this.dWaterOpt.invalidate();
        this.waterOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(0));
        this.dWaterOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(1));
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && facing.func_176740_k() != this.func_195044_w().func_177229_b(CRProperties.HORIZ_AXIS)) {
            return this.waterOpt;
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != null && facing.func_176740_k() == this.func_195044_w().func_177229_b(CRProperties.HORIZ_AXIS)) {
            return this.dWaterOpt;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.saltOpt;
        }
        if (cap == Capabilities.AXLE_CAPABILITY && facing == Direction.UP) {
            return this.axleOpt;
        }
        return super.getCapability(cap, facing);
    }

    @Override
    public double getMoInertia() {
        return 50.0;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.water_centrifuge");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new WaterCentrifugeContainer(i, playerInventory, this.createContainerBuf());
    }
}

