/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.heat;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.alchemy.EnumTransferMode;
import com.Da_Technomancer.crossroads.API.heat.HeatInsulators;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.heat.IHeatHandler;
import com.Da_Technomancer.crossroads.API.templates.ConduitBlock;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.CRConfig;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class HeatCableTileEntity
extends ModuleTE
implements ConduitBlock.IConduitTE<EnumTransferMode> {
    @ObjectHolder(value="heat_cable")
    private static TileEntityType<HeatCableTileEntity> type = null;
    protected final LazyOptional<IHeatHandler>[] neighCache = new LazyOptional[]{LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty(), LazyOptional.empty()};
    protected HeatInsulators insulator;
    protected boolean[] matches = new boolean[6];
    protected EnumTransferMode[] modes = ConduitBlock.IConduitTE.genModeArray(EnumTransferMode.BOTH);

    public HeatCableTileEntity() {
        this(HeatInsulators.WOOL);
    }

    public HeatCableTileEntity(HeatInsulators insulator) {
        super(type);
        this.insulator = insulator;
    }

    protected HeatCableTileEntity(TileEntityType<? extends HeatCableTileEntity> type) {
        super(type);
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.heatOpt.invalidate();
        this.heatOpt = LazyOptional.of(this::createHeatHandler);
    }

    @Override
    protected boolean useHeat() {
        return true;
    }

    @Override
    protected ModuleTE.HeatHandler createHeatHandler() {
        return new CableHeatHandler();
    }

    protected boolean locked(int side) {
        return !this.modes[side].isConnection();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        double prevTemp = this.temp;
        ArrayList<IHeatHandler> heatHandlers = new ArrayList<IHeatHandler>(6);
        for (Direction side : Direction.values()) {
            TileEntity te;
            if (this.locked(side.func_176745_a())) continue;
            LazyOptional otherOpt = this.neighCache[side.func_176745_a()];
            if (!this.neighCache[side.func_176745_a()].isPresent() && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side))) != null) {
                this.neighCache[side.func_176745_a()] = otherOpt = te.getCapability(Capabilities.HEAT_CAPABILITY, side.func_176734_d());
            }
            if (otherOpt.isPresent()) {
                IHeatHandler handler = (IHeatHandler)otherOpt.orElseThrow(NullPointerException::new);
                this.temp += handler.getTemp();
                handler.addHeat(-handler.getTemp());
                heatHandlers.add(handler);
                this.setData(side.func_176745_a(), true, (Comparable)((Object)this.modes[side.func_176745_a()]));
                continue;
            }
            this.setData(side.func_176745_a(), false, (Comparable)((Object)this.modes[side.func_176745_a()]));
        }
        this.temp /= (double)(heatHandlers.size() + 1);
        for (IHeatHandler handler : heatHandlers) {
            handler.addHeat(this.temp);
        }
        this.temp = this.runLoss();
        if (this.temp != prevTemp) {
            this.func_70296_d();
        }
        if (this.temp > this.insulator.getLimit()) {
            if (((Boolean)CRConfig.heatEffects.get()).booleanValue()) {
                this.insulator.getEffect().doEffect(this.field_145850_b, this.field_174879_c);
            } else {
                this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150480_ab.func_176223_P(), 3);
            }
        }
    }

    protected double runLoss() {
        double biomeTemp = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
        return this.temp + Math.min(this.insulator.getRate(), Math.abs(this.temp - biomeTemp)) * Math.signum(biomeTemp - this.temp);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        ConduitBlock.IConduitTE.readConduitNBT(nbt, this);
        this.insulator = nbt.func_74764_b("insul") ? HeatInsulators.valueOf(nbt.func_74779_i("insul")) : HeatInsulators.WOOL;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        ConduitBlock.IConduitTE.writeConduitNBT(nbt, this);
        nbt.func_74778_a("insul", this.insulator.name());
        return nbt;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(super.func_189517_E_());
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!(capability != Capabilities.HEAT_CAPABILITY || facing != null && this.locked(facing.func_176745_a()))) {
            return this.heatOpt;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @Nonnull
    public boolean[] getHasMatch() {
        return this.matches;
    }

    @Nonnull
    public EnumTransferMode[] getModes() {
        return this.modes;
    }

    @Override
    @Nonnull
    public EnumTransferMode deserialize(String name) {
        return ConduitBlock.IConduitTE.deserializeEnumMode(name);
    }

    @Override
    public boolean hasMatch(int side, EnumTransferMode mode) {
        Direction face = Direction.func_82600_a((int)side);
        TileEntity neighTE = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(face));
        return neighTE != null && neighTE.getCapability(Capabilities.HEAT_CAPABILITY, face.func_176734_d()).isPresent();
    }

    private class CableHeatHandler
    extends ModuleTE.HeatHandler {
        private CableHeatHandler() {
        }

        @Override
        public void init() {
            if (!HeatCableTileEntity.this.initHeat) {
                if (HeatCableTileEntity.this.insulator == HeatInsulators.ICE) {
                    HeatCableTileEntity.this.temp = -10.0;
                } else {
                    HeatCableTileEntity.this.temp = HeatUtil.convertBiomeTemp(HeatCableTileEntity.this.field_145850_b, HeatCableTileEntity.this.field_174879_c);
                }
                HeatCableTileEntity.this.initHeat = true;
                HeatCableTileEntity.this.func_70296_d();
            }
        }
    }
}

