/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.heat;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class HeatSinkTileEntity
extends ModuleTE {
    @ObjectHolder(value="heat_sink")
    private static TileEntityType<HeatSinkTileEntity> type = null;
    public static final int[] MODES = new int[]{5, 10, 15, 20, 25};
    private int mode = 0;

    public HeatSinkTileEntity() {
        super(type);
    }

    public int cycleMode() {
        this.mode = (this.mode + 1) % MODES.length;
        this.func_70296_d();
        return this.mode;
    }

    @Override
    protected boolean useHeat() {
        return true;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.heat_sink.loss", new Object[]{MODES[this.mode]}));
        super.addInfo(chat, player, hit);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        double prevTemp = this.temp;
        double biomeTemp = HeatUtil.convertBiomeTemp(this.field_145850_b, this.field_174879_c);
        this.temp += Math.min((double)MODES[this.mode], Math.abs(this.temp - biomeTemp)) * Math.signum(biomeTemp - this.temp);
        if (this.temp != prevTemp) {
            this.func_70296_d();
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.mode = nbt.func_74762_e("mode");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("mode", this.mode);
        return nbt;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == Capabilities.HEAT_CAPABILITY) {
            return this.heatOpt;
        }
        return super.getCapability(capability, facing);
    }
}

