/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.heat;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.packets.IStringReceiver;
import com.Da_Technomancer.crossroads.API.packets.SendStringToClient;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.gui.container.CrucibleContainer;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.CrucibleRec;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class HeatingCrucibleTileEntity
extends InventoryTE
implements IStringReceiver {
    @ObjectHolder(value="crucible")
    public static TileEntityType<HeatingCrucibleTileEntity> type = null;
    public static final int[] TEMP_TIERS = new int[]{1000, 1500, 2500};
    public static final int USAGE = 20;
    public static final int REQUIRED = 1000;
    private int progress = 0;
    public IntReferenceHolder progressRef = IntReferenceHolder.func_221492_a();
    @Nullable
    private ResourceLocation activeText = null;
    private Integer col = null;
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());

    public HeatingCrucibleTileEntity() {
        super(type, 1);
        this.fluidProps[0] = new ModuleTE.TankProperty(4000, false, true);
        this.initFluidManagers();
    }

    @Override
    protected int fluidTanks() {
        return 1;
    }

    @Override
    protected boolean useHeat() {
        return true;
    }

    @Override
    public void receiveString(byte context, String message, @Nullable ServerPlayerEntity sender) {
        if (this.field_145850_b.field_72995_K) {
            if (context == 0) {
                this.activeText = message.length() == 0 ? null : new ResourceLocation(message);
            } else if (context == 1) {
                try {
                    this.col = Integer.valueOf(message);
                }
                catch (NumberFormatException e) {
                    this.col = null;
                }
            }
        }
    }

    public ResourceLocation getActiveTexture() {
        return this.activeText;
    }

    public Color getCol() {
        return this.activeText == null ? Color.WHITE : (this.col == null ? Color.WHITE : new Color(this.col));
    }

    @Override
    public void func_73660_a() {
        int tier;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 2L == 0L) {
            int fullness = Math.min(3, (int)Math.ceil((float)this.fluids[0].getAmount() * 3.0f / (float)this.fluidProps[0].capacity));
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() != CRBlocks.heatingCrucible) {
                this.func_145843_s();
                return;
            }
            if ((Integer)state.func_177229_b((Property)CRProperties.FULLNESS) != fullness) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)CRProperties.FULLNESS, (Comparable)Integer.valueOf(fullness)), 18);
            }
            if (fullness != 0 && !this.fluids[0].isEmpty()) {
                ResourceLocation goal = this.fluids[0].getFluid().getAttributes().getStillTexture();
                if (!goal.equals((Object)this.activeText)) {
                    this.activeText = goal;
                    this.col = this.fluids[0].getFluid().getAttributes().getColor(this.fluids[0]);
                    CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, new SendStringToClient(0, this.activeText.toString(), this.field_174879_c));
                    CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, new SendStringToClient(1, Integer.toString(this.col), this.field_174879_c));
                }
            } else if (this.activeText != null) {
                this.activeText = null;
                CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, new SendStringToClient(0, "", this.field_174879_c));
            }
        }
        if ((tier = HeatUtil.getHeatTier(this.temp, TEMP_TIERS)) >= 0) {
            this.temp -= (double)(20 * (tier + 1));
            if (this.inventory[0].func_190926_b()) {
                this.progress = 0;
            } else {
                this.progress = Math.min(1000, this.progress + 20 * (tier + 1));
                if (this.progress >= 1000) {
                    Optional recOpt = this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.CRUCIBLE_TYPE, (IInventory)this, this.field_145850_b);
                    if (recOpt.isPresent()) {
                        FluidStack created = ((CrucibleRec)recOpt.get()).getOutput();
                        if (this.fluidProps[0].capacity - this.fluids[0].getAmount() >= created.getAmount() && (this.fluids[0].isEmpty() || BlockUtil.sameFluid((FluidStack)this.fluids[0], (FluidStack)created))) {
                            this.progress = 0;
                            if (this.fluids[0].isEmpty()) {
                                this.fluids[0] = created.copy();
                            } else {
                                this.fluids[0].grow(created.getAmount());
                            }
                            this.inventory[0].func_190918_g(1);
                            this.func_70296_d();
                        }
                    } else {
                        this.inventory[0] = ItemStack.field_190927_a;
                    }
                }
            }
            this.progressRef.func_221494_a(this.progress);
            this.func_70296_d();
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        String textStr = nbt.func_74779_i("act");
        this.activeText = textStr.length() == 0 ? null : new ResourceLocation(textStr);
        this.col = nbt.func_74764_b("col") ? Integer.valueOf(nbt.func_74762_e("col")) : null;
        this.progress = nbt.func_74762_e("prog");
        this.progressRef.func_221494_a(this.progress);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("act", this.activeText == null ? "" : this.activeText.toString());
        if (this.col != null) {
            nbt.func_74768_a("col", this.col.intValue());
        }
        nbt.func_74768_a("prog", this.progress);
        return nbt;
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74778_a("act", this.activeText == null ? "" : this.activeText.toString());
        if (this.col != null) {
            nbt.func_74768_a("col", this.col.intValue());
        }
        return nbt;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing != Direction.UP) {
            return this.globalFluidOpt;
        }
        if (capability == Capabilities.HEAT_CAPABILITY && facing != Direction.UP) {
            return this.heatOpt;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.CRUCIBLE_TYPE, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b).isPresent();
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.crucible");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new CrucibleContainer(id, playerInventory, this.createContainerBuf());
    }
}

