/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.heat;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.heat.HeatInsulators;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.tileentities.heat.HeatCableTileEntity;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class RedstoneHeatCableTileEntity
extends HeatCableTileEntity {
    @ObjectHolder(value="redstone_heat_cable")
    private static TileEntityType<RedstoneHeatCableTileEntity> type = null;

    public RedstoneHeatCableTileEntity() {
        this(HeatInsulators.WOOL);
    }

    public RedstoneHeatCableTileEntity(HeatInsulators insulator) {
        super((TileEntityType<? extends HeatCableTileEntity>)type);
        this.insulator = insulator;
    }

    private boolean isUnlocked() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)ESProperties.REDSTONE_BOOL);
    }

    @Override
    public void func_73660_a() {
        if (this.isUnlocked()) {
            super.func_73660_a();
        } else {
            double prevTemp = this.temp;
            this.temp = this.runLoss();
            if (this.temp != prevTemp) {
                this.func_70296_d();
            }
            if (this.temp > this.insulator.getLimit()) {
                if (((Boolean)CRConfig.heatEffects.get()).booleanValue()) {
                    this.insulator.getEffect().doEffect(this.field_145850_b, this.field_174879_c);
                } else {
                    this.field_145850_b.func_180501_a(this.field_174879_c, Blocks.field_150480_ab.func_176223_P(), 3);
                }
            }
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.HEAT_CAPABILITY) {
            if ((facing == null || !this.locked(facing.func_176745_a())) && this.isUnlocked()) {
                return this.heatOpt;
            }
            return LazyOptional.empty();
        }
        return super.getCapability(capability, facing);
    }

    public float getTemp() {
        return (float)HeatUtil.toKelvin(this.temp);
    }
}

