/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.heat;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.container.SaltReactorContainer;
import com.Da_Technomancer.crossroads.items.crafting.CRItemTags;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class SaltReactorTileEntity
extends InventoryTE {
    @ObjectHolder(value="salt_reactor")
    private static TileEntityType<SaltReactorTileEntity> type = null;
    private static final int WATER_USE = 200;
    public static final double COOLING = 5.0;
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());
    private final LazyOptional<IFluidHandler> inputFluidOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(0));
    private final LazyOptional<IFluidHandler> outputFluidOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(1));

    public SaltReactorTileEntity() {
        super(type, 1);
        this.fluidProps[0] = new ModuleTE.TankProperty(3200, true, false, f -> f == CRFluids.distilledWater.still);
        this.fluidProps[1] = new ModuleTE.TankProperty(3200, false, true);
        this.initFluidManagers();
    }

    @Override
    public int fluidTanks() {
        return 2;
    }

    @Override
    public boolean useHeat() {
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.temp >= -268.0 && this.fluids[0].getAmount() >= 200 && this.fluidProps[1].capacity - this.fluids[1].getAmount() >= 200 && !this.inventory[0].func_190926_b()) {
            this.temp -= 5.0;
            this.fluids[0].shrink(200);
            this.inventory[0].func_190918_g(1);
            if (this.fluids[1].isEmpty()) {
                this.fluids[1] = new FluidStack((Fluid)Fluids.field_204546_a, 200);
            } else {
                this.fluids[1].grow(200);
            }
            this.func_70296_d();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
        this.inputFluidOpt.invalidate();
        this.outputFluidOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.inputFluidOpt;
            }
            if (facing != null) {
                return this.outputFluidOpt;
            }
        }
        if (capability == Capabilities.HEAT_CAPABILITY && facing == Direction.DOWN) {
            return this.heatOpt;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && (CRItemTags.SALT.func_230235_a_((Object)stack.func_77973_b()) || CRItemTags.ALC_SALT.func_230235_a_((Object)stack.func_77973_b()));
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.salt_reactor");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new SaltReactorContainer(id, playerInv, this.createContainerBuf());
    }
}

