/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.heat;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.heat.HeatUtil;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.gui.container.SmelterContainer;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class SmelterTileEntity
extends InventoryTE {
    @ObjectHolder(value="smelter")
    private static TileEntityType<SmelterTileEntity> type = null;
    public static final int REQUIRED = 500;
    public static final int[] TEMP_TIERS = new int[]{200, 300};
    public static final int USAGE = 5;
    private int progress = 0;
    private LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());

    public SmelterTileEntity() {
        super(type, 2);
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    protected boolean useHeat() {
        return true;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.progress", new Object[]{this.progress, 500}));
        super.addInfo(chat, player, hit);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int tier = HeatUtil.getHeatTier(this.temp, TEMP_TIERS);
        if (tier != -1) {
            this.temp -= (double)(5 * (tier + 1));
            ItemStack output = this.getOutput();
            if (!this.inventory[0].func_190926_b() && !output.func_190926_b()) {
                this.progress += 5 * (tier + 1);
                if (this.progress >= 500) {
                    this.progress = 0;
                    if (this.inventory[1].func_190926_b()) {
                        this.inventory[1] = output;
                    } else {
                        this.inventory[1].func_190917_f(output.func_190916_E());
                    }
                    this.inventory[0].func_190918_g(1);
                }
            } else {
                this.progress = 0;
            }
            this.func_70296_d();
        }
    }

    private ItemStack getOutput() {
        ItemStack stack;
        Optional recOpt = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)this, this.field_145850_b);
        ItemStack itemStack = stack = recOpt.isPresent() ? ((FurnaceRecipe)recOpt.get()).func_77571_b() : ItemStack.field_190927_a;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.inventory[1].func_190926_b() && !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)this.inventory[1])) {
            return ItemStack.field_190927_a;
        }
        if (!this.inventory[1].func_190926_b() && this.func_70297_j_() - this.inventory[1].func_190916_E() < stack.func_190916_E()) {
            return ItemStack.field_190927_a;
        }
        return stack.func_77946_l();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.progress = nbt.func_74762_e("prog");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("prog", this.progress);
        return nbt;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.HEAT_CAPABILITY && (side == Direction.UP || side == null)) {
            return this.heatOpt;
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != Direction.UP) {
            return this.itemOpt;
        }
        return super.getCapability(cap, side);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b).isPresent();
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.smelter");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new SmelterContainer(id, playerInventory, this.createContainerBuf());
    }
}

