/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.gui.container.BlastFurnaceContainer;
import com.Da_Technomancer.crossroads.items.CRItems;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.BlastFurnaceRec;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class BlastFurnaceTileEntity
extends InventoryTE {
    @ObjectHolder(value="ind_blast_furnace")
    private static TileEntityType<BlastFurnaceTileEntity> type = null;
    public static final int CARBON_LIMIT = 32;
    public static final double POWER = 5.0;
    public static final double REQUIRED_SPD = 2.5;
    public static final int REQUIRED_PRG = 40;
    public static final double INERTIA = 200.0;
    private int carbon = 0;
    private int progress = 0;
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());

    public BlastFurnaceTileEntity() {
        super(type, 3);
        this.fluidProps[0] = new ModuleTE.TankProperty(4000, false, true);
        this.initFluidManagers();
    }

    public int getCarbon() {
        return this.carbon;
    }

    public int getProgress() {
        return this.progress;
    }

    @Override
    protected int fluidTanks() {
        return 1;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.progress", new Object[]{this.progress, 40}));
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.blast_furnace.carbon", new Object[]{this.carbon}));
        super.addInfo(chat, player, hit);
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    @Override
    public double getMoInertia() {
        return 200.0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int carbonAvailable = BlastFurnaceTileEntity.getCarbonValue(this.inventory[1]);
        if (this.carbon < 32 && carbonAvailable != 0 && carbonAvailable + this.carbon <= 32) {
            this.carbon += carbonAvailable;
            this.inventory[1].func_190918_g(1);
            this.func_70296_d();
        }
        if (Math.abs(this.motData[0]) < 2.5) {
            this.progress = 0;
            return;
        }
        Optional recOpt = this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.BLAST_FURNACE_TYPE, (IInventory)this, this.field_145850_b);
        if (!recOpt.isPresent()) {
            this.progress = 0;
            return;
        }
        BlastFurnaceRec recipe = (BlastFurnaceRec)recOpt.get();
        if (this.carbon < recipe.getSlag() || this.inventory[2].func_190916_E() + recipe.getSlag() > CRItems.slag.getItemStackLimit(this.inventory[2]) || !this.fluids[0].isEmpty() && (!BlockUtil.sameFluid((FluidStack)recipe.getOutput(), (FluidStack)this.fluids[0]) || this.fluidProps[0].capacity < this.fluids[0].getAmount() + recipe.getOutput().getAmount())) {
            this.progress = 0;
            return;
        }
        ++this.progress;
        this.axleHandler.addEnergy(-5.0, false);
        this.func_70296_d();
        if (this.progress >= 40) {
            this.progress = 0;
            this.inventory[0].func_190918_g(1);
            this.carbon -= recipe.getSlag();
            if (this.inventory[2].func_190926_b()) {
                this.inventory[2] = new ItemStack((IItemProvider)CRItems.slag, recipe.getSlag());
            } else {
                this.inventory[2].func_190917_f(recipe.getSlag());
            }
            if (this.fluids[0].isEmpty()) {
                this.fluids[0] = recipe.getOutput().copy();
            } else {
                this.fluids[0].grow(recipe.getOutput().getAmount());
            }
        }
    }

    private static int getCarbonValue(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151044_h) {
            return 16;
        }
        return 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 2;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.BLAST_FURNACE_TYPE, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b).isPresent() || index == 1 && BlastFurnaceTileEntity.getCarbonValue(stack) != 0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("prog", this.progress);
        nbt.func_74768_a("carbon", this.carbon);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.progress = nbt.func_74762_e("prog");
        this.carbon = nbt.func_74762_e("carbon");
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.blast_furnace");
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        if (cap == Capabilities.AXLE_CAPABILITY && (side == Direction.UP || side == null)) {
            return this.axleOpt;
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.globalFluidOpt;
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new BlastFurnaceContainer(id, playerInv, this.createContainerBuf());
    }
}

