/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.ICogHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.rotary.LargeGearMasterTileEntity;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class LargeGearSlaveTileEntity
extends TileEntity
implements IInfoTE {
    @ObjectHolder(value="large_gear_slave")
    private static TileEntityType<LargeGearSlaveTileEntity> type = null;
    public BlockPos masterPos;
    private Direction facing = null;
    private final ICogHandler handler = new CogHandler();
    private final LazyOptional<ICogHandler> cogOpt = LazyOptional.of(() -> this.handler);

    public LargeGearSlaveTileEntity() {
        super(type);
    }

    protected Direction getFacing() {
        if (this.facing == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() != CRBlocks.largeGearSlave) {
                this.func_145843_s();
                return Direction.NORTH;
            }
            this.facing = (Direction)state.func_177229_b((Property)ESProperties.FACING);
        }
        return this.facing;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        IAxleHandler axle = this.handler.getAxle();
        if (axle == null) {
            return;
        }
        RotaryUtil.addRotaryInfo(chat, axle.getMotionData(), axle.getMoInertia(), axle.getRotationRatio(), false);
    }

    public void setInitial(BlockPos masPos) {
        this.masterPos = masPos;
    }

    public void passBreak(Direction side, boolean drop) {
        TileEntity te;
        if (this.masterPos != null && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177971_a((Vector3i)this.masterPos))) instanceof LargeGearMasterTileEntity) {
            ((LargeGearMasterTileEntity)te).breakGroup(side, drop);
        }
    }

    private boolean isEdge() {
        return this.masterPos != null && this.masterPos.func_218139_n((Vector3i)BlockPos.field_177992_a) == 1;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.masterPos != null) {
            nbt.func_74772_a("mast", this.masterPos.func_218275_a());
        }
        return nbt;
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.masterPos = BlockPos.func_218283_e((long)nbt.func_74763_f("mast"));
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        if (this.masterPos != null) {
            nbt.func_74772_a("mast", this.masterPos.func_218275_a());
        }
        return nbt;
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.cogOpt.invalidate();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == Capabilities.COG_CAPABILITY && this.isEdge() && this.getFacing() == facing) {
            return this.cogOpt;
        }
        return super.getCapability(capability, facing);
    }

    private class CogHandler
    implements ICogHandler {
        private CogHandler() {
        }

        @Override
        public void connect(IAxisHandler masterIn, byte key, double rotationRatioIn, double lastRadius, Direction cogOrient, boolean renderOffset) {
            if (cogOrient == Direction.func_176737_a((float)(-LargeGearSlaveTileEntity.this.masterPos.func_177958_n()), (float)(-LargeGearSlaveTileEntity.this.masterPos.func_177956_o()), (float)(-LargeGearSlaveTileEntity.this.masterPos.func_177952_p()))) {
                this.getAxle().propogate(masterIn, key, rotationRatioIn, lastRadius, !renderOffset);
            }
        }

        @Override
        public IAxleHandler getAxle() {
            TileEntity te = LargeGearSlaveTileEntity.this.field_145850_b.func_175625_s(LargeGearSlaveTileEntity.this.field_174879_c.func_177971_a((Vector3i)LargeGearSlaveTileEntity.this.masterPos));
            if (te instanceof LargeGearMasterTileEntity) {
                LazyOptional axleOpt = te.getCapability(Capabilities.AXLE_CAPABILITY, LargeGearSlaveTileEntity.this.getFacing());
                return axleOpt.isPresent() ? (IAxleHandler)axleOpt.orElseThrow(NullPointerException::new) : null;
            }
            return null;
        }
    }
}

