/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.gui.container.MillstoneContainer;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.MillRec;
import com.Da_Technomancer.essentials.blocks.BlockUtil;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class MillstoneTileEntity
extends InventoryTE {
    @ObjectHolder(value="millstone")
    private static TileEntityType<MillstoneTileEntity> type = null;
    private double progress = 0.0;
    public static final double REQUIRED = 400.0;
    public static final double PEAK_SPEED = 5.0;
    public static final double POWER = 10.0;
    public static final double INERTIA = 200.0;
    private final LazyOptional<IItemHandler> itemOpt = LazyOptional.of(() -> new InventoryTE.ItemHandler());

    public MillstoneTileEntity() {
        super(type, 4);
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.boilerplate.progress", new Object[]{(int)this.progress, 400}));
        super.addInfo(chat, player, hit);
    }

    public int getProgress() {
        return (int)this.progress;
    }

    private void createOutput(ItemStack[] outputs) {
        if (this.canFit(outputs)) {
            this.inventory[0].func_190918_g(1);
            for (ItemStack stack : outputs) {
                int slot;
                int remain = stack.func_190916_E();
                for (slot = 1; slot < 4; ++slot) {
                    if (remain <= 0 || !BlockUtil.sameItem((ItemStack)this.inventory[slot], (ItemStack)stack)) continue;
                    int stored = stack.func_77976_d() - this.inventory[slot].func_190916_E();
                    this.inventory[slot].func_190917_f(Math.min(stored, remain));
                    remain -= stored;
                }
                for (slot = 1; slot < 4 && remain > 0; ++slot) {
                    if (!this.inventory[slot].func_190926_b()) continue;
                    this.inventory[slot] = stack.func_77946_l();
                    this.inventory[slot].func_190920_e(Math.min(stack.func_77976_d(), remain));
                    remain -= Math.min(stack.func_77976_d(), remain);
                }
            }
            this.func_70296_d();
        }
    }

    private boolean canFit(ItemStack[] outputs) {
        boolean viable = true;
        ArrayList<Integer> locked = new ArrayList<Integer>();
        for (ItemStack stack : outputs) {
            int remain = stack.func_190916_E();
            for (int slot : new int[]{1, 2, 3}) {
                if (locked.contains(slot) || !BlockUtil.sameItem((ItemStack)this.inventory[slot], (ItemStack)stack)) continue;
                remain -= stack.func_77976_d() - this.inventory[slot].func_190916_E();
            }
            for (int slot : new int[]{1, 2, 3}) {
                if (locked.contains(slot) || remain <= 0 || !this.inventory[slot].func_190926_b()) continue;
                remain -= stack.func_77976_d();
                locked.add(slot);
            }
            if (remain <= 0) continue;
            viable = false;
            break;
        }
        return viable;
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.inventory[0].func_190926_b()) {
                this.progress = 0.0;
            } else {
                Optional recOpt = this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.MILL_TYPE, (IInventory)this, this.field_145850_b);
                if (recOpt.isPresent()) {
                    double used = 10.0 * RotaryUtil.findEfficiency(this.motData[0], 0.2, 5.0);
                    this.progress += used;
                    this.axleHandler.addEnergy(-used, false);
                    if (this.progress >= 400.0) {
                        this.createOutput(((MillRec)recOpt.get()).getOutputs());
                        this.progress = 0.0;
                    }
                } else {
                    this.progress = 0.0;
                }
            }
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.itemOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemOpt;
        }
        if (cap == Capabilities.AXLE_CAPABILITY && side == Direction.UP) {
            return this.axleOpt;
        }
        return super.getCapability(cap, side);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index > 0 && index < 4;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.MILL_TYPE, (IInventory)new Inventory(new ItemStack[]{stack}), this.field_145850_b).isPresent();
    }

    @Override
    public double getMoInertia() {
        return 200.0;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("prog", this.progress);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.progress = nbt.func_74769_h("prog");
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.millstone");
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new MillstoneContainer(id, playerInv, this.createContainerBuf());
    }
}

