/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.rotary;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.blocks.rotary.RotaryDrill;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import com.mojang.authlib.GameProfile;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class RotaryDrillTileEntity
extends ModuleTE {
    @ObjectHolder(value="rotary_drill")
    public static TileEntityType<RotaryDrillTileEntity> type = null;
    private static final DamageSource DRILL = new DamageSource("drill");
    private int ticksExisted = 0;
    private boolean golden;
    public static final double ENERGY_USE = 2.0;
    private static final double SPEED_PER_HARDNESS = 0.2;
    private static final float DAMAGE_PER_SPEED = 5.0f;
    public static final double[] INERTIA = new double[]{50.0, 100.0};

    public RotaryDrillTileEntity() {
        super(type);
    }

    public RotaryDrillTileEntity(boolean golden) {
        super(type);
        this.golden = golden;
    }

    public boolean isGolden() {
        return this.golden;
    }

    @Override
    protected boolean useRotary() {
        return true;
    }

    @Override
    protected ModuleTE.AxleHandler createAxleHandler() {
        return new ModuleTE.AngleAxleHandler();
    }

    @Override
    protected double getMoInertia() {
        return INERTIA[this.golden ? 1 : 0];
    }

    private Direction getFacing() {
        BlockState state = this.func_195044_w();
        if (state.func_177230_c() instanceof RotaryDrill) {
            return (Direction)state.func_177229_b((Property)ESProperties.FACING);
        }
        this.func_145843_s();
        return Direction.UP;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.axleOpt.invalidate();
        this.axleOpt = LazyOptional.of(this::createAxleHandler);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (Math.abs(this.motData[1]) >= 2.0 && Math.abs(this.motData[0]) >= 0.05) {
            this.axleHandler.addEnergy(-2.0, false);
            if (++this.ticksExisted % 8 == 0) {
                float hardness;
                Direction facing = this.getFacing();
                BlockPos targetPos = this.field_174879_c.func_177972_a(facing);
                BlockState targetState = this.field_145850_b.func_180495_p(targetPos);
                if (!targetState.isAir((IBlockReader)this.field_145850_b, targetPos) && (hardness = targetState.func_185887_b((IBlockReader)this.field_145850_b, targetPos)) >= 0.0f && Math.abs(this.motData[0]) >= (double)hardness * 0.2) {
                    this.field_145850_b.func_175655_b(targetPos, true);
                }
                List ents = this.field_145850_b.func_175647_a(LivingEntity.class, new AxisAlignedBB(this.field_174879_c.func_177972_a(facing)), EntityPredicates.field_94557_a);
                for (LivingEntity ent : ents) {
                    ent.func_70097_a((DamageSource)(this.golden ? new EntityDamageSource("drill", (Entity)FakePlayerFactory.get((ServerWorld)((ServerWorld)this.field_145850_b), (GameProfile)new GameProfile(null, "drill_player_" + MiscUtil.getDimensionName(this.field_145850_b)))) : DRILL), (float)Math.abs(this.motData[0]) * 5.0f);
                }
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("gold", this.golden);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.golden = nbt.func_74767_n("gold");
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        nbt.func_74757_a("gold", this.golden);
        return nbt;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == Capabilities.AXLE_CAPABILITY && (side == null || side == this.getFacing().func_176734_d())) {
            return this.axleOpt;
        }
        return super.getCapability(cap, side);
    }
}

