/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.BeamUnitStorage;
import com.Da_Technomancer.crossroads.API.templates.BeamRenderTE;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.essentials.blocks.ESProperties;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class ClockworkStabilizerTileEntity
extends BeamRenderTE {
    @ObjectHolder(value="clock_stab")
    public static TileEntityType<ClockworkStabilizerTileEntity> type = null;
    public static final double RATE = 0.2;
    private BeamUnitStorage storage = new BeamUnitStorage();
    private Direction dir = null;

    public ClockworkStabilizerTileEntity() {
        super(type);
    }

    @Override
    protected int getLimit() {
        return (int)((double)super.getLimit() / 0.2);
    }

    private Direction getDir() {
        if (this.dir == null) {
            BlockState state = this.func_195044_w();
            if (state.func_177230_c() != CRBlocks.clockworkStabilizer) {
                return Direction.NORTH;
            }
            this.dir = (Direction)state.func_177229_b((Property)ESProperties.FACING);
        }
        return this.dir;
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        this.dir = null;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.storage.writeToNBT("stab_mag", nbt);
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.storage = BeamUnitStorage.readFromNBT("stab_mag", nbt);
    }

    @Override
    protected void doEmit(BeamUnit toEmit) {
        this.storage.addBeam(toEmit);
        if (this.storage.getPower() > this.getLimit()) {
            BeamUnit stored = this.storage.getOutput();
            this.storage.clear();
            this.storage.addBeam(stored.mult((double)this.getLimit() / (double)stored.getPower(), true));
        }
        Direction dir = this.getDir();
        if (!this.storage.isEmpty()) {
            double toWithdraw = 0.2 * (double)this.storage.getPower();
            toWithdraw = toWithdraw < 1.0 ? 1.0 : (double)Math.round(toWithdraw);
            BeamUnit output = new BeamUnit(MiscUtil.withdrawExact(this.storage.getOutput().getValues(), (int)toWithdraw));
            this.storage.subtractBeam(output);
            if (this.beamer[dir.func_176745_a()].emit(output, this.field_145850_b)) {
                this.refreshBeam(dir.func_176745_a());
            }
        } else if (this.beamer[dir.func_176745_a()].emit(BeamUnit.EMPTY, this.field_145850_b)) {
            this.refreshBeam(dir.func_176745_a());
        }
    }

    @Override
    protected boolean[] inputSides() {
        boolean[] out = new boolean[]{true, true, true, true, true, true};
        out[this.getDir().func_176745_a()] = false;
        return out;
    }

    @Override
    protected boolean[] outputSides() {
        boolean[] out = new boolean[6];
        out[this.getDir().func_176745_a()] = true;
        return out;
    }

    public int getRedstone() {
        return this.storage.getPower();
    }
}

