/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.beams.IBeamHandler;
import com.Da_Technomancer.crossroads.API.technomancy.FluxUtil;
import com.Da_Technomancer.crossroads.API.technomancy.IFluxLink;
import com.Da_Technomancer.crossroads.API.templates.InventoryTE;
import com.Da_Technomancer.crossroads.API.templates.ModuleTE;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.fluids.CRFluids;
import com.Da_Technomancer.crossroads.gui.container.CopshowiumMakerContainer;
import com.Da_Technomancer.crossroads.items.crafting.CRRecipes;
import com.Da_Technomancer.crossroads.items.crafting.recipes.CopshowiumRec;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class CopshowiumCreationChamberTileEntity
extends InventoryTE
implements IFluxLink {
    @ObjectHolder(value="copshowium_creation_chamber")
    public static TileEntityType<CopshowiumCreationChamberTileEntity> type = null;
    public static final int CAPACITY = 1440;
    public static final int FLUX_PER_INGOT = 4;
    private int flux = 0;
    private int fluxToTrans = 0;
    private final HashSet<BlockPos> link = new HashSet(1);
    private final LazyOptional<IFluidHandler> inputOpt = LazyOptional.of(() -> new ModuleTE.FluidTankHandler(0));
    private final LazyOptional<IFluidHandler> outputOpt = LazyOptional.of(() -> new ModuleTE.FluidHandler(1));
    private final LazyOptional<IBeamHandler> beamOpt = LazyOptional.of(() -> new BeamHandler());

    public CopshowiumCreationChamberTileEntity() {
        super(type, 0);
        this.fluidProps[0] = new ModuleTE.TankProperty(1440, true, true, f -> f != null && f.getFluid() != CRFluids.moltenCopshowium.still);
        this.fluidProps[1] = new ModuleTE.TankProperty(1440, false, true);
        this.initFluidManagers();
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        FluxUtil.addFluxInfo(chat, this, -1);
        super.addInfo(chat, player, hit);
        FluxUtil.addLinkInfo(chat, this);
    }

    @Override
    protected int fluidTanks() {
        return 2;
    }

    public float getRedstone() {
        return 100.0f * (float)this.fluids[0].getAmount() / 1440.0f;
    }

    public FluidStack getInputFluid() {
        return this.fluids[0];
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_186662_g((double)this.getRange());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        long stage = this.field_145850_b.func_82737_E() % 4L;
        if (stage == 0L && this.flux != 0) {
            this.fluxToTrans += this.flux;
            this.flux = 0;
            this.func_70296_d();
        } else if (stage == 1L) {
            this.flux += FluxUtil.performTransfer(this, this.link, this.fluxToTrans);
            this.fluxToTrans = 0;
            FluxUtil.checkFluxOverload(this);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74768_a("flux_trans", this.fluxToTrans);
        for (BlockPos linked : this.link) {
            nbt.func_74772_a("link", linked.func_218275_a());
        }
        return nbt;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.flux = nbt.func_74762_e("flux");
        this.fluxToTrans = nbt.func_74762_e("flux_trans");
        if (nbt.func_74764_b("link")) {
            this.link.add(BlockPos.func_218283_e((long)nbt.func_74763_f("link")));
        } else {
            this.link.clear();
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        for (BlockPos linked : this.link) {
            nbt.func_74772_a("link", linked.func_218275_a());
        }
        return nbt;
    }

    @Override
    public int getReadingFlux() {
        return FluxUtil.findReadingFlux(this, this.flux, this.fluxToTrans);
    }

    @Override
    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity sendingPlayer) {
        super.receiveLong(identifier, message, sendingPlayer);
        if (identifier == 8) {
            this.link.add(BlockPos.func_218283_e((long)message));
            this.func_70296_d();
        } else if (identifier == 9) {
            this.link.clear();
            this.func_70296_d();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.inputOpt.invalidate();
        this.outputOpt.invalidate();
        this.beamOpt.invalidate();
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return facing == null ? this.globalFluidOpt : (facing == Direction.UP ? this.inputOpt : (facing == Direction.DOWN ? this.outputOpt : LazyOptional.empty()));
        }
        if (capability == Capabilities.BEAM_CAPABILITY && (facing == null || facing.func_176740_k() != Direction.Axis.Y)) {
            return this.beamOpt;
        }
        return super.getCapability(capability, facing);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.copshowium_maker");
    }

    @Override
    public int getFlux() {
        return this.flux;
    }

    @Override
    public void setFlux(int newFlux) {
        this.flux = newFlux;
        this.func_70296_d();
    }

    public Set<BlockPos> getLinks() {
        return this.link;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory playerInv, PlayerEntity player) {
        return new CopshowiumMakerContainer(id, playerInv, this.createContainerBuf());
    }

    private class BeamHandler
    implements IBeamHandler {
        private BeamHandler() {
        }

        @Override
        public void setBeam(BeamUnit mag) {
            if (mag.isEmpty()) {
                return;
            }
            EnumBeamAlignments align = EnumBeamAlignments.getAlignment(mag);
            if (mag.getVoid() != 0) {
                ((CopshowiumCreationChamberTileEntity)CopshowiumCreationChamberTileEntity.this).fluids[0] = FluidStack.EMPTY;
                ((CopshowiumCreationChamberTileEntity)CopshowiumCreationChamberTileEntity.this).fluids[1] = FluidStack.EMPTY;
                CopshowiumCreationChamberTileEntity.this.func_70296_d();
            } else if (!(((Boolean)CRConfig.cccRequireTime.get()).booleanValue() && align != EnumBeamAlignments.TIME || CopshowiumCreationChamberTileEntity.this.fluids[0].isEmpty())) {
                Optional recOpt = CopshowiumCreationChamberTileEntity.this.field_145850_b.func_199532_z().func_215371_a(CRRecipes.COPSHOWIUM_TYPE, (IInventory)CopshowiumCreationChamberTileEntity.this, CopshowiumCreationChamberTileEntity.this.field_145850_b);
                if (recOpt.isPresent()) {
                    CopshowiumRec rec = (CopshowiumRec)recOpt.get();
                    int created = (int)((float)CopshowiumCreationChamberTileEntity.this.fluids[0].getAmount() * rec.getMult());
                    if (CopshowiumCreationChamberTileEntity.this.fluids[1].isEmpty()) {
                        ((CopshowiumCreationChamberTileEntity)CopshowiumCreationChamberTileEntity.this).fluids[1] = new FluidStack((Fluid)CRFluids.moltenCopshowium.still, created);
                    } else {
                        CopshowiumCreationChamberTileEntity.this.fluids[1].grow(created);
                    }
                    ((CopshowiumCreationChamberTileEntity)CopshowiumCreationChamberTileEntity.this).fluids[0] = FluidStack.EMPTY;
                    CopshowiumCreationChamberTileEntity.this.func_70296_d();
                    if (CopshowiumCreationChamberTileEntity.this.fluids[1].getAmount() > 1440) {
                        if (((Boolean)CRConfig.allowOverflow.get()).booleanValue()) {
                            CopshowiumCreationChamberTileEntity.this.field_145850_b.func_175656_a(CopshowiumCreationChamberTileEntity.this.field_174879_c, CRFluids.moltenCopshowium.still.func_207188_f().func_206883_i());
                        } else {
                            CopshowiumCreationChamberTileEntity.this.fluids[1].setAmount(1440);
                        }
                    }
                    if (rec.isFlux()) {
                        CopshowiumCreationChamberTileEntity.this.addFlux(4 * created / 144);
                    }
                } else {
                    ((CopshowiumCreationChamberTileEntity)CopshowiumCreationChamberTileEntity.this).fluids[0] = FluidStack.EMPTY;
                    CopshowiumCreationChamberTileEntity.this.func_70296_d();
                }
            }
        }
    }
}

