/*
 * Decompiled with CFR 0.152.
 */
package com.Da_Technomancer.crossroads.tileentities.technomancy;

import com.Da_Technomancer.crossroads.API.CRProperties;
import com.Da_Technomancer.crossroads.API.Capabilities;
import com.Da_Technomancer.crossroads.API.IInfoTE;
import com.Da_Technomancer.crossroads.API.MiscUtil;
import com.Da_Technomancer.crossroads.API.beams.BeamUnit;
import com.Da_Technomancer.crossroads.API.beams.EnumBeamAlignments;
import com.Da_Technomancer.crossroads.API.beams.IBeamHandler;
import com.Da_Technomancer.crossroads.API.packets.CRPackets;
import com.Da_Technomancer.crossroads.API.rotary.IAxisHandler;
import com.Da_Technomancer.crossroads.API.rotary.IAxleHandler;
import com.Da_Technomancer.crossroads.API.rotary.RotaryUtil;
import com.Da_Technomancer.crossroads.API.technomancy.FluxUtil;
import com.Da_Technomancer.crossroads.API.technomancy.GatewayAddress;
import com.Da_Technomancer.crossroads.API.technomancy.GatewaySavedData;
import com.Da_Technomancer.crossroads.API.technomancy.IFluxLink;
import com.Da_Technomancer.crossroads.CRConfig;
import com.Da_Technomancer.crossroads.blocks.CRBlocks;
import com.Da_Technomancer.crossroads.tileentities.technomancy.GatewayEdgeTileEntity;
import com.Da_Technomancer.essentials.packets.ClientPacket;
import com.Da_Technomancer.essentials.packets.SendLongToClient;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="crossroads")
public class GatewayFrameTileEntity
extends TileEntity
implements ITickableTileEntity,
IInfoTE,
IFluxLink {
    @ObjectHolder(value="gateway_frame")
    public static TileEntityType<GatewayFrameTileEntity> type = null;
    public static final int INERTIA = 0;
    public static final int FLUX_PER_CYCLE = 4;
    private static final float ROTATION_SPEED = 0.07853982f;
    private int flux = 0;
    private int fluxToTrans = 0;
    private final HashSet<BlockPos> links = new HashSet(1);
    private GatewayAddress address = null;
    private final double[] rotary = new double[4];
    private float angle = 0.0f;
    private float clientAngle = 0.0f;
    private float clientW = 0.0f;
    private float referenceSpeed = 0.0f;
    public EnumBeamAlignments[] chevrons = new EnumBeamAlignments[4];
    private boolean origin = false;
    private LazyOptional<IAxleHandler> axleOpt = null;
    private LazyOptional<IBeamHandler> beamOpt = null;
    private int size = 0;
    private Direction.Axis plane = null;

    public int getSize() {
        return this.size;
    }

    @Nullable
    public Direction.Axis getPlane() {
        return this.plane;
    }

    public double getAngle(float partialTicks) {
        return GatewayFrameTileEntity.calcAngleChange(this.clientW, this.clientAngle) * partialTicks + this.clientAngle;
    }

    private static void teleportEntity(Entity e, ServerWorld target, double posX, double posY, double posZ, float yawRotation) {
        if (e instanceof ServerPlayerEntity) {
            target.func_72863_F().func_217228_a(TicketType.field_223185_g, new ChunkPos(new BlockPos(posX, posY, posZ)), 1, (Object)e.func_145782_y());
            e.func_184210_p();
            ServerPlayerEntity play = (ServerPlayerEntity)e;
            if (play.func_70608_bn()) {
                play.func_225652_a_(true, true);
            }
            float prevHeadYaw = play.func_70079_am();
            Vector3d prevVelocity = play.func_213322_ci();
            if (target == e.field_70170_p) {
                play.field_71135_a.func_147364_a(posX, posY, posZ, play.func_195046_g(1.0f) + yawRotation, play.func_195050_f(1.0f));
            } else {
                play.func_200619_a(target, posX, posY, posZ, play.func_195046_g(1.0f) + yawRotation, play.func_195050_f(1.0f));
            }
            play.func_70034_d(prevHeadYaw + yawRotation);
            play.func_213317_d(prevVelocity.func_178785_b(yawRotation));
        } else {
            Vector3d prevVelocity = e.func_213322_ci();
            if (target == e.field_70170_p) {
                float prevHeadYaw = e.func_70079_am();
                e.func_70012_b(posX, posY, posZ, e.func_195046_g(1.0f) + yawRotation, e.func_195050_f(1.0f));
                e.func_70034_d(prevHeadYaw + yawRotation);
            } else {
                e.func_213319_R();
                Entity entity = e;
                e = e.func_200600_R().func_200721_a((World)target);
                if (e == null) {
                    return;
                }
                e.func_180432_n(entity);
                e.func_70012_b(posX, posY, posZ, entity.func_195046_g(1.0f) + yawRotation, entity.func_195050_f(1.0f));
                e.func_70034_d(entity.func_70079_am() + yawRotation);
                target.func_217460_e(e);
                entity.func_70106_y();
            }
            e.func_213317_d(prevVelocity.func_178785_b(yawRotation));
        }
        e.field_71088_bW = 60;
    }

    public GatewayFrameTileEntity() {
        super(type);
    }

    public boolean isActive() {
        BlockState state = this.func_195044_w();
        return state.func_177230_c() == CRBlocks.gatewayFrame && (Boolean)this.func_195044_w().func_177229_b((Property)CRProperties.ACTIVE) != false;
    }

    @Override
    public void addInfo(ArrayList<ITextComponent> chat, PlayerEntity player, BlockRayTraceResult hit) {
        if (this.isActive() && this.address != null) {
            String[] names = new String[4];
            for (int i = 0; i < 4; ++i) {
                EnumBeamAlignments align = this.address.getEntry(i);
                if (align == null) {
                    align = EnumBeamAlignments.NO_MATCH;
                }
                names[i] = align.getLocalName(false);
            }
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.gateway.chevron.address", new Object[]{names[0], names[1], names[2], names[3]}));
            boolean addedPotential = false;
            for (int i = 0; i < 4; ++i) {
                if (this.chevrons[i] == null) {
                    if (addedPotential) {
                        names[i] = MiscUtil.localize("tt.crossroads.gateway.chevron.none");
                        continue;
                    }
                    addedPotential = true;
                    names[i] = String.format("[%s]", GatewayAddress.getLegalEntry(Math.round(this.angle * 8.0f / 2.0f / (float)Math.PI)).getLocalName(false));
                    continue;
                }
                names[i] = this.chevrons[i].getLocalName(false);
            }
            chat.add((ITextComponent)new TranslationTextComponent("tt.crossroads.gateway.chevron.dialed", new Object[]{names[0], names[1], names[2], names[3]}));
            this.genOptionals();
            RotaryUtil.addRotaryInfo(chat, this.rotary, 0.0, ((IAxleHandler)this.axleOpt.orElseGet(() -> new AxleHandler())).getRotationRatio(), true);
            FluxUtil.addFluxInfo(chat, this, this.chevrons[3] != null && this.origin ? 4 : 0);
            FluxUtil.addLinkInfo(chat, this);
        }
    }

    private void undial() {
        GatewayAddress dialed = new GatewayAddress(this.chevrons);
        for (int i = 0; i < 4; ++i) {
            this.chevrons[i] = null;
        }
        this.origin = false;
        if (dialed.fullAddress()) {
            GatewayFrameTileEntity te;
            this.playEffects(false);
            GatewayAddress.Location loc = GatewaySavedData.lookupAddress((ServerWorld)this.field_145850_b, dialed);
            GatewayFrameTileEntity gatewayFrameTileEntity = te = loc == null ? null : loc.evalTE(this.field_145850_b.func_73046_m());
            if (te != null) {
                te.undial();
            }
        }
        this.referenceSpeed = 0.0f;
        this.resyncToClient();
        this.func_70296_d();
        CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(3, 0L, this.field_174879_c));
    }

    private boolean dial(GatewayAddress toLinkTo, boolean source) {
        GatewayFrameTileEntity te;
        this.undial();
        GatewayAddress.Location loc = GatewaySavedData.lookupAddress((ServerWorld)this.field_145850_b, toLinkTo);
        GatewayFrameTileEntity gatewayFrameTileEntity = te = loc == null ? null : loc.evalTE(this.field_145850_b.func_73046_m());
        if (te != null) {
            if (source && !te.dial(this.address, false)) {
                this.playEffects(false);
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                this.chevrons[i] = toLinkTo.getEntry(i);
            }
            this.origin = source;
            this.playEffects(true);
            CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(3, (long)new GatewayAddress(this.chevrons).serialize(), this.field_174879_c));
            return true;
        }
        this.playEffects(false);
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c).func_186662_g((double)Math.max(this.getRange(), this.isActive() ? this.size : 0));
    }

    private void playEffects(boolean success) {
        this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() - 1.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), success ? SoundEvents.field_193781_bp : SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat(), true);
    }

    public void dismantle() {
        if (!this.field_145850_b.field_72995_K && this.isActive()) {
            this.undial();
            GatewaySavedData.releaseAddress((ServerWorld)this.field_145850_b, this.address);
            BlockPos.Mutable mutPos = new BlockPos.Mutable(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
            Direction horiz = this.plane == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
            int preSize = this.size;
            mutPos.func_189534_c(horiz, -preSize / 2);
            for (int i = 0; i < preSize; ++i) {
                for (int j = 0; j < preSize; ++j) {
                    TileEntity te;
                    BlockState otherState = this.field_145850_b.func_180495_p((BlockPos)mutPos);
                    if (otherState.func_177230_c() == CRBlocks.gatewayEdge) {
                        this.field_145850_b.func_175656_a((BlockPos)mutPos, (BlockState)otherState.func_206870_a((Property)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
                    }
                    if ((te = this.field_145850_b.func_175625_s((BlockPos)mutPos)) instanceof GatewayEdgeTileEntity) {
                        GatewayEdgeTileEntity otherTE = (GatewayEdgeTileEntity)te;
                        otherTE.reset();
                    }
                    mutPos.func_189534_c(horiz, 1);
                }
                mutPos.func_189534_c(horiz, -preSize);
                mutPos.func_189534_c(Direction.DOWN, 1);
            }
            BlockState state = this.func_195044_w();
            if (state.func_177230_c() == CRBlocks.gatewayFrame) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
            this.size = 0;
            this.plane = null;
            this.axleOpt = null;
            this.beamOpt = null;
            this.address = null;
            this.origin = false;
            this.func_70296_d();
            this.func_145836_u();
        }
    }

    public boolean assemble() {
        BlockState otherState;
        int j;
        int i;
        Direction.Axis axis;
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (((Boolean)this.func_195044_w().func_177229_b((Property)CRProperties.ACTIVE)).booleanValue()) {
            return false;
        }
        int newSize = 0;
        BlockPos.Mutable mutPos = new BlockPos.Mutable(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        boolean foundAir = false;
        int foundThickness = 1;
        for (int i2 = 1; i2 < 63; ++i2) {
            mutPos.func_189536_c(Direction.DOWN);
            BlockState state = this.field_145850_b.func_180495_p((BlockPos)mutPos);
            if (GatewayFrameTileEntity.legalForGateway(state)) {
                if (foundAir) {
                    newSize = i2 + foundThickness;
                    break;
                }
                ++foundThickness;
                continue;
            }
            if (!state.isAir((IBlockReader)this.field_145850_b, (BlockPos)mutPos)) {
                return false;
            }
            foundAir = true;
        }
        if (newSize < 5 || newSize % 2 == 0) {
            return false;
        }
        if (GatewayFrameTileEntity.legalForGateway(this.field_145850_b.func_180495_p(this.field_174879_c.func_177974_f())) && GatewayFrameTileEntity.legalForGateway(this.field_145850_b.func_180495_p(this.field_174879_c.func_177976_e()))) {
            axis = Direction.Axis.X;
        } else if (GatewayFrameTileEntity.legalForGateway(this.field_145850_b.func_180495_p(this.field_174879_c.func_177968_d())) && GatewayFrameTileEntity.legalForGateway(this.field_145850_b.func_180495_p(this.field_174879_c.func_177978_c()))) {
            axis = Direction.Axis.Z;
        } else {
            return false;
        }
        this.size = newSize;
        this.plane = axis;
        int thickness = Math.max(1, this.size / 5);
        Direction horiz = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        mutPos.func_189533_g((Vector3i)this.field_174879_c).func_189534_c(horiz, -this.size / 2);
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                otherState = this.field_145850_b.func_180495_p((BlockPos)mutPos);
                if (!(i >= thickness && this.size - i > thickness && j >= thickness && this.size - j > thickness || i == 0 && j == this.size / 2 || GatewayFrameTileEntity.legalForGateway(otherState))) {
                    return false;
                }
                mutPos.func_189534_c(horiz, 1);
            }
            mutPos.func_189534_c(horiz, -this.size);
            mutPos.func_189534_c(Direction.DOWN, 1);
        }
        this.address = GatewaySavedData.requestAddress((ServerWorld)this.field_145850_b, this.field_174879_c);
        if (this.address == null) {
            return false;
        }
        this.axleOpt = null;
        this.beamOpt = null;
        mutPos.func_189533_g((Vector3i)this.field_174879_c).func_189534_c(horiz, -this.size / 2);
        for (i = 0; i < this.size; ++i) {
            for (j = 0; j < this.size; ++j) {
                otherState = this.field_145850_b.func_180495_p((BlockPos)mutPos);
                if (i < thickness || this.size - i <= thickness || j < thickness || this.size - j <= thickness) {
                    this.field_145850_b.func_175656_a((BlockPos)mutPos, (BlockState)otherState.func_206870_a((Property)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(true)));
                    TileEntity te = this.field_145850_b.func_175625_s((BlockPos)mutPos);
                    if (te instanceof GatewayEdgeTileEntity) {
                        GatewayEdgeTileEntity otherTE = (GatewayEdgeTileEntity)te;
                        otherTE.setKey(this.field_174879_c.func_177973_b((Vector3i)mutPos));
                        otherTE.func_145836_u();
                    }
                }
                mutPos.func_189534_c(horiz, 1);
            }
            mutPos.func_189534_c(horiz, -this.size);
            mutPos.func_189534_c(Direction.DOWN, 1);
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)CRProperties.ACTIVE, (Comparable)Boolean.valueOf(true)));
        this.func_145836_u();
        CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(5, (long)(this.plane.ordinal() | this.size << 2), this.field_174879_c));
        return true;
    }

    private static boolean legalForGateway(BlockState state) {
        return state.func_177230_c() == CRBlocks.gatewayEdge && (Boolean)state.func_177229_b((Property)CRProperties.ACTIVE) == false;
    }

    @Override
    public int getReadingFlux() {
        return FluxUtil.findReadingFlux(this, this.flux, this.fluxToTrans);
    }

    public void func_73660_a() {
        if (this.isActive()) {
            this.clientAngle += GatewayFrameTileEntity.calcAngleChange(this.clientW, this.clientAngle);
            if (!this.field_145850_b.field_72995_K) {
                long stage;
                float angleTarget = (float)this.rotary[0] - this.referenceSpeed;
                this.angle += GatewayFrameTileEntity.calcAngleChange(angleTarget, this.angle);
                double errorMargin = 0.09817477042468103;
                if ((double)Math.abs(this.clientAngle - this.angle) >= 0.09817477042468103 || (double)Math.abs(this.clientW - angleTarget) >= 0.04908738521234052) {
                    this.resyncToClient();
                }
                if (this.chevrons[3] != null && this.plane != null) {
                    GatewayAddress.Location loc;
                    Direction horiz = Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.plane);
                    AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c.func_177979_c(this.size).func_177967_a(horiz, -this.size / 2), this.field_174879_c.func_177967_a(horiz, this.size / 2 + 1));
                    List entities = this.field_145850_b.func_175647_a(Entity.class, area, EntityPredicates.field_94557_a.and(e -> e.field_71088_bW <= 0));
                    if (!entities.isEmpty() && (loc = GatewaySavedData.lookupAddress((ServerWorld)this.field_145850_b, new GatewayAddress(this.chevrons))) != null) {
                        World targetWorld;
                        GatewayFrameTileEntity otherTE = loc.evalTE(this.field_145850_b.func_73046_m());
                        BlockPos endPos = loc.pos;
                        float distMult = 1.0f;
                        float rotate = 0.0f;
                        if (otherTE != null && otherTE.plane != null) {
                            rotate = otherTE.plane == this.plane ? 0.0f : 90.0f;
                            distMult = (float)otherTE.size / (float)this.size;
                        }
                        if ((targetWorld = loc.evalDim(this.field_145850_b.func_73046_m())) == null) {
                            return;
                        }
                        for (Entity e2 : entities) {
                            GatewayFrameTileEntity.playTPEffect(this.field_145850_b, e2.func_226277_ct_(), e2.func_226278_cu_(), e2.func_226281_cx_());
                            GatewayFrameTileEntity.teleportEntity(e2, (ServerWorld)targetWorld, (e2.func_226277_ct_() - (double)this.field_174879_c.func_177958_n()) * (double)distMult + (double)endPos.func_177958_n(), (e2.func_226278_cu_() - (double)this.field_174879_c.func_177956_o()) * (double)distMult + (double)endPos.func_177956_o(), (e2.func_226281_cx_() - (double)this.field_174879_c.func_177952_p()) * (double)distMult + (double)endPos.func_177952_p(), rotate);
                            GatewayFrameTileEntity.playTPEffect(targetWorld, e2.func_226277_ct_(), e2.func_226278_cu_(), e2.func_226281_cx_());
                        }
                    }
                }
                if ((stage = this.field_145850_b.func_82737_E() % 4L) == 0L) {
                    if (this.origin) {
                        this.flux += 4;
                    }
                    if (this.flux != 0) {
                        this.fluxToTrans += this.flux;
                        this.flux = 0;
                        this.func_70296_d();
                    }
                } else if (stage == 1L) {
                    this.flux += FluxUtil.performTransfer(this, this.links, this.fluxToTrans);
                    this.fluxToTrans = 0;
                    FluxUtil.checkFluxOverload(this);
                }
            }
        }
    }

    private static float calcAngleChange(float target, float current) {
        float pi2 = (float)Math.PI * 2;
        float angleChange = target % ((float)Math.PI * 2) - current % ((float)Math.PI * 2);
        if ((double)angleChange > Math.PI || (double)angleChange < -Math.PI) {
            angleChange = angleChange > 0.0f ? (angleChange -= (float)Math.PI * 2) : (angleChange += (float)Math.PI * 2);
        }
        angleChange = MathHelper.func_76131_a((float)angleChange, (float)-0.07853982f, (float)0.07853982f);
        return angleChange;
    }

    private static void playTPEffect(World world, double xPos, double yPos, double zPos) {
        for (int i = 0; i < 10; ++i) {
            world.func_195589_b((IParticleData)ParticleTypes.field_197601_L, xPos + Math.random() - 0.5, yPos + Math.random() - 0.5, zPos + Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5);
        }
        world.func_184134_a(xPos, yPos, zPos, SoundEvents.field_187812_eh, SoundCategory.BLOCKS, 1.0f, (float)Math.random(), true);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.flux = nbt.func_74762_e("flux");
        this.fluxToTrans = nbt.func_74762_e("flux_trans");
        if (nbt.func_74764_b("link")) {
            this.links.add(BlockPos.func_218283_e((long)nbt.func_74763_f("link")));
        } else {
            this.links.clear();
        }
        this.address = nbt.func_74764_b("address") ? GatewayAddress.deserialize(nbt.func_74762_e("address")) : null;
        for (int i = 0; i < 4; ++i) {
            this.rotary[i] = nbt.func_74769_h("rot_" + i);
            this.chevrons[i] = nbt.func_74764_b("chev_" + i) ? EnumBeamAlignments.values()[nbt.func_74762_e("chev_" + i)] : null;
        }
        this.clientW = (float)this.rotary[0];
        this.clientAngle = this.angle = nbt.func_74760_g("angle");
        this.referenceSpeed = nbt.func_74760_g("reference");
        this.origin = nbt.func_74767_n("origin");
        this.size = nbt.func_74762_e("size");
        this.plane = nbt.func_74764_b("plane") ? Direction.Axis.values()[nbt.func_74762_e("plane")] : null;
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74768_a("flux_trans", this.fluxToTrans);
        if (this.links.size() == 1) {
            nbt.func_74772_a("link", this.links.iterator().next().func_218275_a());
        }
        if (this.address != null) {
            nbt.func_74768_a("address", this.address.serialize());
        }
        for (int i = 0; i < 4; ++i) {
            nbt.func_74780_a("rot_" + i, this.rotary[i]);
            if (this.chevrons[i] == null) continue;
            nbt.func_74768_a("chev_" + i, this.chevrons[i].ordinal());
        }
        nbt.func_74776_a("angle", this.angle);
        nbt.func_74776_a("reference", this.referenceSpeed);
        nbt.func_74757_a("origin", this.origin);
        nbt.func_74768_a("size", this.size);
        if (this.plane != null) {
            nbt.func_74768_a("plane", this.plane.ordinal());
        }
        return nbt;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT nbt = super.func_189517_E_();
        if (this.links.size() == 1) {
            nbt.func_74772_a("link", this.links.iterator().next().func_218275_a());
        }
        for (int i = 0; i < 4; ++i) {
            nbt.func_74780_a("rot_" + i, this.rotary[i]);
            if (this.chevrons[i] == null) continue;
            nbt.func_74768_a("chev_" + i, this.chevrons[i].ordinal());
        }
        nbt.func_74776_a("angle", this.angle);
        nbt.func_74768_a("size", this.size);
        if (this.plane != null) {
            nbt.func_74768_a("plane", this.plane.ordinal());
        }
        return nbt;
    }

    private void resyncToClient() {
        this.clientAngle = this.angle;
        this.clientW = (float)this.rotary[0] - this.referenceSpeed;
        long packet = Integer.toUnsignedLong(Float.floatToRawIntBits(this.clientAngle)) << 32 | Integer.toUnsignedLong(Float.floatToRawIntBits(this.clientW));
        CRPackets.sendPacketAround(this.field_145850_b, this.field_174879_c, (ClientPacket)new SendLongToClient(4, packet, this.field_174879_c));
    }

    @Override
    public int getFlux() {
        return this.flux;
    }

    @Override
    public void setFlux(int newFlux) {
        this.flux = newFlux;
        this.func_70296_d();
    }

    public Set<BlockPos> getLinks() {
        return this.links;
    }

    private void genOptionals() {
        if (this.axleOpt == null) {
            if (this.isActive()) {
                this.axleOpt = LazyOptional.of(() -> new AxleHandler());
                this.beamOpt = LazyOptional.of(() -> new BeamHandler());
            } else {
                this.axleOpt = LazyOptional.empty();
                this.beamOpt = LazyOptional.empty();
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.axleOpt != null) {
            this.axleOpt.invalidate();
        }
        if (this.beamOpt != null) {
            this.beamOpt.invalidate();
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (this.isActive()) {
            this.genOptionals();
            if (cap == Capabilities.AXLE_CAPABILITY && (side == null || side == Direction.UP)) {
                return this.axleOpt;
            }
            if (cap == Capabilities.BEAM_CAPABILITY) {
                return this.beamOpt;
            }
        }
        return super.getCapability(cap, side);
    }

    public void receiveLong(byte identifier, long message, @Nullable ServerPlayerEntity player) {
        switch (identifier) {
            case 8: {
                this.links.add(BlockPos.func_218283_e((long)message));
                this.func_70296_d();
                break;
            }
            case 9: {
                this.links.clear();
                this.func_70296_d();
                break;
            }
            case 3: {
                GatewayAddress add = GatewayAddress.deserialize((int)message);
                for (int i = 0; i < 4; ++i) {
                    this.chevrons[i] = add.getEntry(i);
                }
                break;
            }
            case 4: {
                this.clientAngle = Float.intBitsToFloat((int)(message >>> 32));
                this.clientW = Float.intBitsToFloat((int)(message & 0xFFFFFFFFL));
                break;
            }
            case 5: {
                this.plane = Direction.Axis.values()[(int)(message & 3L)];
                this.size = (int)(message >>> 2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    private class BeamHandler
    implements IBeamHandler {
        private BeamHandler() {
        }

        @Override
        public void setBeam(@Nonnull BeamUnit mag) {
            if (mag.isEmpty()) {
                return;
            }
            if (GatewayFrameTileEntity.this.chevrons[3] != null) {
                GatewayFrameTileEntity.this.undial();
                return;
            }
            int index = 0;
            for (int i = 0; i < 4; ++i) {
                if (GatewayFrameTileEntity.this.chevrons[i] != null) continue;
                index = i;
                break;
            }
            EnumBeamAlignments alignment = GatewayAddress.getLegalEntry(Math.round(GatewayFrameTileEntity.this.angle * 8.0f / 2.0f / (float)Math.PI));
            if (((Boolean)CRConfig.hardGateway.get()).booleanValue() && alignment != EnumBeamAlignments.getAlignment(mag)) {
                GatewayFrameTileEntity.this.undial();
                return;
            }
            GatewayFrameTileEntity.this.chevrons[index] = alignment;
            GatewayFrameTileEntity.this.referenceSpeed = (float)GatewayFrameTileEntity.this.rotary[0];
            if (index == 3) {
                GatewayFrameTileEntity.this.dial(new GatewayAddress(GatewayFrameTileEntity.this.chevrons), true);
                GatewayFrameTileEntity.this.referenceSpeed = 0.0f;
            }
            GatewayFrameTileEntity.this.resyncToClient();
            CRPackets.sendPacketAround(GatewayFrameTileEntity.this.field_145850_b, GatewayFrameTileEntity.this.field_174879_c, (ClientPacket)new SendLongToClient(3, (long)new GatewayAddress(GatewayFrameTileEntity.this.chevrons).serialize(), GatewayFrameTileEntity.this.field_174879_c));
            GatewayFrameTileEntity.this.func_70296_d();
        }
    }

    private class AxleHandler
    implements IAxleHandler {
        public double rotRatio;
        public byte updateKey;
        public IAxisHandler axis;

        private AxleHandler() {
        }

        @Override
        public void propogate(IAxisHandler masterIn, byte key, double rotRatioIn, double lastRadius, boolean renderOffset) {
            if (key == this.updateKey || masterIn.addToList(this)) {
                return;
            }
            this.rotRatio = rotRatioIn == 0.0 ? 1.0 : rotRatioIn;
            this.updateKey = key;
            this.axis = masterIn;
        }

        @Override
        public double getRotationRatio() {
            return this.rotRatio;
        }

        @Override
        public void markChanged() {
            GatewayFrameTileEntity.this.func_70296_d();
        }

        @Override
        public float getAngle(float partialTicks) {
            return GatewayFrameTileEntity.this.clientAngle + partialTicks * GatewayFrameTileEntity.this.clientW / 20.0f;
        }

        @Override
        public void disconnect() {
            this.axis = null;
        }

        @Override
        public double[] getMotionData() {
            return GatewayFrameTileEntity.this.rotary;
        }

        @Override
        public double getMoInertia() {
            return 0.0;
        }
    }
}

