/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.style;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;

public class CircleStyle
extends CrosshairStyle {
    public CircleStyle() {
        super("Circle");
    }

    @Override
    public void draw(CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        boolean outlineEnabled = crosshair.getPropertyValue("outline_enabled", Boolean.class);
        int thickness = crosshair.getPropertyValue("crosshair_thickness", Integer.class);
        if (outlineEnabled) {
            this.drawOutline(crosshair, x, y, computedProperties.getGap(), thickness);
        }
        RenderManager.drawTorus(x, y, computedProperties.getGap(), computedProperties.getGap() + thickness, computedProperties.getColour(), true);
    }

    private void drawOutline(CustomCrosshair crosshair, int x, int y, int renderGap, int thickness) {
        RGBA outlineColour = crosshair.getPropertyValue("outline_colour", RGBA.class);
        RenderManager.drawCircle(x, y, (float)renderGap + 0.5f + (float)thickness, 2.0f, outlineColour, true);
        RenderManager.drawCircle(x, y, (float)renderGap - 0.5f, 2.0f, outlineColour, true);
    }
}

