/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.wjbaker.ccm.object.Points;
import com.wjbaker.ccm.object.RGBA;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_4590;
import org.lwjgl.opengl.GL11;

public abstract class RenderManager {
    private static final class_1159 MATRIX = class_4590.method_22931().method_22936();

    private RenderManager() {
    }

    public static void pre() {
        GL11.glPushMatrix();
    }

    public static void post() {
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        GL11.glPopMatrix();
    }

    private static void toggleProperty(int property, boolean enable) {
        if (enable) {
            GL11.glEnable((int)property);
        } else {
            GL11.glDisable((int)property);
        }
    }

    public static void colour(RGBA colour) {
        GL11.glColor4f((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
    }

    public static void drawLines(Points _points, float thickness, RGBA colour, boolean smooth) {
        RenderManager.toggleProperty(2848, smooth);
        RenderManager.colour(colour);
        GL11.glLineWidth((float)thickness);
        float[] points = _points.get();
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(1, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.method_22918(MATRIX, points[i], points[i + 1], 0.0f).method_22915(r, g, b, a).method_1344();
        }
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawLine(float x1, float y1, float x2, float y2, float thickness, RGBA colour, boolean smooth) {
        RenderManager.drawLines(new Points(x1, y1, x2, y2), thickness, colour, smooth);
    }

    public static void drawRectangle(float x1, float y1, float x2, float y2, float thickness, RGBA colour, boolean smooth) {
        Points points = new Points(x1, y1, x2, y1, x2, y1, x2, y2, x1, y2, x2, y2, x1, y1, x1, y2);
        RenderManager.drawLines(points, thickness, colour, smooth);
    }

    public static void drawFilledShape(Points _points, RGBA colour, boolean smooth) {
        RenderManager.toggleProperty(2848, smooth);
        float[] points = _points.get();
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(9, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.method_22918(MATRIX, points[i], points[i + 1], 0.0f).method_22915(r, g, b, a).method_1344();
        }
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawFilledRectangle(float x1, float y1, float x2, float y2, RGBA colour, boolean smooth) {
        Points points = new Points(x1, y1, x1, y2, x2, y2, x2, y1);
        RenderManager.drawFilledShape(points, colour, smooth);
    }

    public static void drawBorderedRectangle(float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour, boolean smooth) {
        RenderManager.drawFilledRectangle(x1, y1, x2, y2, fillColour, smooth);
        RenderManager.drawRectangle(x1, y1, x2, y2, borderThickness, borderColour, smooth);
    }

    public static void drawPartialCircle(float x, float y, float radius, int _startAngle, int _endAngle, float thickness, RGBA colour, boolean smooth) {
        RenderManager.toggleProperty(2848, smooth);
        int startAngle = Math.max(0, Math.min(_startAngle, _endAngle));
        int endAngle = Math.min(360, Math.max(_startAngle, _endAngle));
        GL11.glLineWidth((float)thickness);
        float ratio = (float)Math.PI / 180;
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(1, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        for (int i = startAngle; i <= endAngle; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.method_22918(MATRIX, x + (float)Math.cos(radians) * radius, y + (float)Math.sin(radians) * radius, 0.0f).method_22915(r, g, b, a).method_1344();
        }
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawCircle(float x, float y, float radius, float thickness, RGBA colour, boolean smooth) {
        RenderManager.drawPartialCircle(x, y, radius, 0, 360, thickness, colour, smooth);
    }

    public static void drawTorus(int x, int y, int innerRadius, int outerRadius, RGBA colour, boolean smooth) {
        RenderManager.toggleProperty(2848, smooth);
        RenderManager.colour(colour);
        float ratio = (float)Math.PI / 180;
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(1, class_290.field_1576);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i <= 360; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.method_22918(MATRIX, (float)x + (float)Math.cos(radians) * (float)innerRadius, (float)y + (float)Math.sin(radians) * (float)innerRadius, 0.0f).method_22915(r, g, b, a).method_1344();
            bufferBuilder.method_22918(MATRIX, (float)x + (float)Math.cos(radians) * (float)outerRadius, (float)y + (float)Math.sin(radians) * (float)outerRadius, 0.0f).method_22915(r, g, b, a).method_1344();
        }
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawString(String text, int x, int y, int colour) {
        class_310.method_1551().field_1772.method_1729(text, (float)x, (float)y, colour);
    }

    public static void drawStringWidthShadow(String text, int x, int y, int colour) {
        class_310.method_1551().field_1772.method_1720(text, (float)x, (float)y, colour);
    }

    public static int getStringWidth(String text) {
        return class_310.method_1551().field_1772.method_1727(text);
    }
}

