/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.object.RGBA;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;

public class ComputedProperties {
    private final Minecraft mc;
    private final CustomCrosshair crosshair;
    private final int gap;
    private final RGBA colour;
    private final boolean doRender;
    private final Map<Item, Float> usageItems = ImmutableMap.of((Object)Items.field_151031_f, (Object)Float.valueOf(20.0f), (Object)Items.field_203184_eO, (Object)Float.valueOf(10.0f), (Object)Items.field_222114_py, (Object)Float.valueOf(0.0f));
    private final Set<Item> attackableItems = ImmutableSet.of((Object)Items.field_151041_m, (Object)Items.field_151010_B, (Object)Items.field_151052_q, (Object)Items.field_151040_l, (Object)Items.field_151048_u, (Object)Items.field_151053_p, (Object[])new Item[]{Items.field_151006_E, Items.field_151049_t, Items.field_151036_c, Items.field_151056_x, Items.field_151038_n, Items.field_151011_C, Items.field_151051_r, Items.field_151037_a, Items.field_151047_v, Items.field_151039_o, Items.field_151005_D, Items.field_151050_s, Items.field_151035_b, Items.field_151046_w, Items.field_151017_I, Items.field_151013_M, Items.field_151018_J, Items.field_151019_K, Items.field_151012_L, Items.field_203184_eO});

    public ComputedProperties(CustomCrosshair crosshair) {
        this.mc = Minecraft.func_71410_x();
        this.crosshair = crosshair;
        this.gap = this.computeGap();
        this.colour = this.computeColour();
        this.doRender = this.computeDoRender();
    }

    public int getGap() {
        return this.gap;
    }

    private int computeGap() {
        int originalGap = this.crosshair.getPropertyValue("crosshair_gap", Integer.class);
        if (this.mc.field_71439_g == null) {
            return originalGap;
        }
        boolean isSpectator = this.mc.field_71439_g.func_175149_v();
        boolean isHoldingItem = !this.mc.field_71439_g.func_184586_b(Hand.OFF_HAND).func_190926_b() || !this.mc.field_71439_g.func_184586_b(Hand.MAIN_HAND).func_190926_b();
        boolean dynamicBowEnabled = this.crosshair.getPropertyValue("dynamic_bow_enabled", Boolean.class);
        boolean dynamicAttackIndicatorEnabled = this.crosshair.getPropertyValue("dynamic_attackindicator_enabled", Boolean.class);
        if (!isSpectator && isHoldingItem && (dynamicAttackIndicatorEnabled || dynamicBowEnabled)) {
            float gapModifier = 2.0f;
            Float usageItem = this.usageItems.get(this.mc.field_71439_g.func_184607_cu().func_77973_b());
            if (dynamicBowEnabled && usageItem != null) {
                float progress;
                if (this.mc.field_71439_g.func_184607_cu().func_77973_b() == Items.field_222114_py) {
                    usageItem = Float.valueOf(CrossbowItem.func_220026_e((ItemStack)this.mc.field_71439_g.func_184607_cu()));
                    progress = Math.min(usageItem.floatValue(), usageItem.floatValue() - (float)this.mc.field_71439_g.func_184605_cv());
                } else {
                    progress = Math.min(usageItem.floatValue(), (float)this.mc.field_71439_g.func_184612_cw());
                }
                return originalGap + Math.round((usageItem.floatValue() - progress) * gapModifier);
            }
            if (dynamicAttackIndicatorEnabled && this.attackableItems.contains(this.mc.field_71439_g.func_184586_b(Hand.MAIN_HAND).func_77973_b())) {
                float currentAttackUsage = this.mc.field_71439_g.func_184825_o(1.0f);
                float maxAttackUsage = 1.0f;
                if (this.mc.field_71439_g.func_184818_cX() > 5.0f && currentAttackUsage < maxAttackUsage) {
                    return originalGap + Math.round((maxAttackUsage - currentAttackUsage) * gapModifier * 20.0f);
                }
            }
        }
        return originalGap;
    }

    public RGBA getColour() {
        return this.colour;
    }

    private RGBA computeColour() {
        RGBA originalColour = this.crosshair.getPropertyValue("crosshair_colour", RGBA.class);
        if (this.mc.field_147125_j == null) {
            if (this.crosshair.getPropertyValue("rainbow_enabled", Boolean.class).booleanValue()) {
                return this.getRainbowColour();
            }
            return originalColour;
        }
        boolean isHighlightPlayerEnabled = this.crosshair.getPropertyValue("highlight_players_enabled", Boolean.class);
        if (isHighlightPlayerEnabled && this.mc.field_147125_j instanceof PlayerEntity) {
            return this.crosshair.getPropertyValue("highlight_players_colour", RGBA.class);
        }
        boolean isHighlightHostileEnabled = this.crosshair.getPropertyValue("highlight_hostile_enabled", Boolean.class);
        if (isHighlightHostileEnabled && this.mc.field_147125_j instanceof MonsterEntity) {
            return this.crosshair.getPropertyValue("highlight_hostile_colour", RGBA.class);
        }
        boolean isHighlightPassiveEnabled = this.crosshair.getPropertyValue("highlight_passive_enabled", Boolean.class);
        if (isHighlightPassiveEnabled && this.mc.field_147125_j instanceof MobEntity) {
            return this.crosshair.getPropertyValue("highlight_passive_colour", RGBA.class);
        }
        return originalColour;
    }

    private RGBA getRainbowColour() {
        ++this.crosshair.rainbowTicks;
        if (this.crosshair.rainbowTicks > 125000) {
            this.crosshair.rainbowTicks = 0;
        }
        int opacity = this.crosshair.getPropertyValue("crosshair_colour", RGBA.class).getOpacity();
        return new RGBA(255, 255, 255, opacity).setRed(this.getRainbowColourComponent(0.0f)).setGreen(this.getRainbowColourComponent(2.0f)).setBlue(this.getRainbowColourComponent(4.0f));
    }

    private int getRainbowColourComponent(float offset) {
        int speed = this.crosshair.getPropertyValue("rainbow_speed", Integer.class);
        return (int)(Math.sin((float)(this.crosshair.rainbowTicks * speed) / 20000.0f + offset) * 127.0 + 128.0);
    }

    public boolean doRender() {
        return this.doRender;
    }

    private boolean computeDoRender() {
        boolean enabled = this.crosshair.getPropertyValue("mod_enabled", Boolean.class);
        boolean visibleDefault = this.visibleDefault();
        boolean visibleDebug = this.visibleDebug();
        boolean visibleThirdPerson = this.visibleThirdPerson();
        boolean visibleHiddenGUI = this.visibleHiddenGUI();
        boolean visibleSpectator = this.visibleSpectator();
        return enabled && (visibleDefault || visibleDebug || visibleThirdPerson || visibleHiddenGUI || visibleSpectator);
    }

    private boolean visibleDefault() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_default", Boolean.class);
        return !this.mc.field_71474_y.field_74330_P && this.mc.field_71474_y.field_74320_O == 0 && !this.mc.field_71474_y.field_74319_N && this.mc.field_71439_g != null && !this.mc.field_71439_g.func_175149_v() && propertyValue;
    }

    private boolean visibleDebug() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_debug", Boolean.class);
        return this.mc.field_71474_y.field_74330_P && propertyValue;
    }

    private boolean visibleThirdPerson() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_thirdperson", Boolean.class);
        return this.mc.field_71474_y.field_74320_O > 0 && propertyValue;
    }

    private boolean visibleHiddenGUI() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_hiddengui", Boolean.class);
        return this.mc.field_71474_y.field_74319_N && propertyValue;
    }

    private boolean visibleSpectator() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_spectator", Boolean.class);
        return this.mc.field_71439_g != null && this.mc.field_71439_g.func_175149_v() && propertyValue;
    }
}

