/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.crosshair.style.CrosshairStyleFactory;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import org.lwjgl.opengl.GL11;

public class CrosshairRenderer {
    private final List<Item> itemCooldownItems = Arrays.asList(Items.field_151079_bi, Items.field_185161_cS);

    public void render(CustomCrosshair crosshair, int x, int y) {
        CrosshairStyle style = CrosshairStyleFactory.getStyle(crosshair.getPropertyValue("crosshair_style", Integer.class));
        boolean isCooldownIndicatorEnabled = crosshair.getPropertyValue("itemcooldown_enabled", Boolean.class);
        boolean isDotEnabled = crosshair.getPropertyValue("dot_enabled", Boolean.class);
        RenderManager.pre();
        Minecraft.func_71410_x().field_195558_d.func_216522_a(Minecraft.field_142025_a);
        ComputedProperties computedProperties = new ComputedProperties(crosshair);
        if (isCooldownIndicatorEnabled) {
            this.drawItemCooldownIndicator(crosshair, computedProperties, x, y);
        }
        if (isDotEnabled) {
            RGBA dotColour = crosshair.getPropertyValue("dot_colour", RGBA.class);
            RenderManager.drawCircle(x, y, 0.5f, 1.0f, dotColour, true);
        }
        this.preRotation(crosshair, x, y);
        style.draw(crosshair, computedProperties, x, y);
        this.postRotation();
        RenderManager.post();
    }

    private void preRotation(CustomCrosshair crosshair, int x, int y) {
        int rotation = crosshair.getPropertyValue("crosshair_rotation", Integer.class);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glRotatef((float)rotation, (float)x, (float)y, (float)8000.0f);
        GL11.glTranslatef((float)(-x), (float)(-y), (float)0.0f);
    }

    private void postRotation() {
        GL11.glPopMatrix();
    }

    private void drawItemCooldownIndicator(CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        RGBA colour = crosshair.getPropertyValue("itemcooldown_colour", RGBA.class);
        int gap = crosshair.getPropertyValue("crosshair_gap", Integer.class);
        int width = crosshair.getPropertyValue("crosshair_width", Integer.class);
        int height = crosshair.getPropertyValue("crosshair_height", Integer.class);
        int maxSize = Math.max(width, height);
        int offset = 3;
        for (Item item : this.itemCooldownItems) {
            float cooldown = player.func_184811_cZ().func_185143_a(item, 0.0f);
            if (cooldown == 0.0f) continue;
            int progress = Math.round(360.0f - 360.0f * cooldown);
            RenderManager.drawPartialCircle(x, y, gap + maxSize + offset, 0, progress, 2.0f, colour, true);
            offset += 3;
        }
    }
}

