/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.style;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.object.Points;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;

public class TriangleStyle
extends CrosshairStyle {
    public TriangleStyle() {
        super("Triangle");
    }

    @Override
    public void draw(CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        boolean outlineEnabled = crosshair.getPropertyValue("outline_enabled", Boolean.class);
        int width = crosshair.getPropertyValue("crosshair_width", Integer.class);
        int height = crosshair.getPropertyValue("crosshair_height", Integer.class);
        if (outlineEnabled) {
            this.drawOutline(crosshair, x, y, computedProperties.getGap(), width, height);
        }
        this.drawTriangle(x, y, computedProperties.getGap(), width, height, computedProperties.getColour());
    }

    private void drawTriangle(int x, int y, int gap, int width, int height, RGBA colour) {
        Points points = new Points(x, (float)y - (float)height / 2.0f - (float)gap, (float)x + (float)width / 2.0f + (float)gap, (float)y + (float)height / 2.0f + (float)gap, (float)x + (float)width / 2.0f + (float)gap, (float)y + (float)height / 2.0f + (float)gap, (float)x - (float)width / 2.0f - (float)gap, (float)y + (float)height / 2.0f + (float)gap, (float)x - (float)width / 2.0f - (float)gap, (float)y + (float)height / 2.0f + (float)gap, x, (float)y - (float)height / 2.0f - (float)gap);
        RenderManager.drawLines(points, 1.0f, colour, true);
    }

    private void drawOutline(CustomCrosshair crosshair, int x, int y, int gap, int width, int height) {
        RGBA renderColour = crosshair.getPropertyValue("outline_colour", RGBA.class);
        Points points = new Points(x, (float)y - (float)height / 2.0f - (float)gap - 0.5f, (float)x + (float)width / 2.0f + (float)gap + 1.0f, (float)y + (float)height / 2.0f + (float)gap + 0.5f, (float)x + (float)width / 2.0f + (float)gap + 1.0f, (float)y + (float)height / 2.0f + (float)gap + 0.5f, (float)x - (float)width / 2.0f - (float)gap - 1.0f, (float)y + (float)height / 2.0f + (float)gap + 0.5f, (float)x - (float)width / 2.0f - (float)gap - 1.0f, (float)y + (float)height / 2.0f + (float)gap + 0.5f, x, (float)y - (float)height / 2.0f - (float)gap - 1.0f);
        Points innerPoints = new Points(x, (float)y - (float)height / 2.0f - (float)gap + 0.5f, (float)x + (float)width / 2.0f + (float)gap - 1.0f, (float)y + (float)height / 2.0f + (float)gap - 0.5f, (float)x + (float)width / 2.0f + (float)gap - 1.0f, (float)y + (float)height / 2.0f + (float)gap - 0.5f, (float)x - (float)width / 2.0f - (float)gap + 1.0f, (float)y + (float)height / 2.0f + (float)gap - 0.5f, (float)x - (float)width / 2.0f - (float)gap + 1.0f, (float)y + (float)height / 2.0f + (float)gap - 0.5f, x, (float)y - (float)height / 2.0f - (float)gap + 1.0f);
        RenderManager.drawLines(points, 2.0f, renderColour, true);
        RenderManager.drawLines(innerPoints, 2.0f, renderColour, true);
    }
}

