/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.components;

import com.wjbaker.ccm.gui.components.interfaces.ComponentStyle;
import com.wjbaker.ccm.gui.components.interfaces.IComponentMouseEvents;
import com.wjbaker.ccm.gui.screens.Screen;
import com.wjbaker.ccm.object.Bounds;
import java.util.ArrayList;
import java.util.List;

public abstract class Component
extends ComponentStyle
implements IComponentMouseEvents {
    protected List<Component> components;
    protected String label;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean isMouseOver;
    protected String boundProperty;
    private Screen parentScreen;
    private Bounds bounds;

    public Component(Screen parentScreen, String label, int x, int y, int width, int height) {
        this.label = label;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.components = new ArrayList<Component>();
        this.bounds = new Bounds(this.y, this.x + this.width, this.y + this.height, this.x);
        this.parentScreen = parentScreen;
    }

    public void drawComponent() {
    }

    public void bindProperty(String alias) {
        this.boundProperty = alias;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public boolean isWithinBounds(int x, int y) {
        return x > this.getBounds().getLeft() - 1 && x < this.getBounds().getRight() + 1 && y > this.getBounds().getTop() - 1 && y < this.getBounds().getBottom() + 1;
    }

    @Override
    public void onMouseEnter() {
        this.currentBackgroundColour = this.hoverBackgroundColour;
        this.currentBorderColour = this.hoverBorderColour;
        this.currentTextColour = this.hoverTextColour;
    }

    @Override
    public void onMouseLeave() {
        this.currentBackgroundColour = this.backgroundColour;
        this.currentBorderColour = this.borderColour;
        this.currentTextColour = this.textColour;
    }

    @Override
    public void setMouseOver(boolean isMouseOver) {
        if (this.isMouseOver != isMouseOver) {
            if (isMouseOver) {
                this.onMouseEnter();
            } else {
                this.onMouseLeave();
            }
            this.isMouseOver = isMouseOver;
        }
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        this.components.forEach(component -> {
            if (component.isWithinBounds(mouseX, mouseY)) {
                component.setMouseOver(true);
                component.onMouseMove(mouseX, mouseY);
            } else {
                component.setMouseOver(false);
            }
        });
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY) {
        this.components.forEach(component -> {
            if (!component.isWithinBounds(mouseX, mouseY)) {
                return;
            }
            component.onMouseUp(mouseX, mouseY);
        });
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY) {
        this.components.forEach(component -> {
            if (!component.isWithinBounds(mouseX, mouseY)) {
                return;
            }
            component.onMouseDown(mouseX, mouseY);
        });
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY, long dragTime) {
        this.components.forEach(component -> component.onMouseDrag(startX, startY, mouseX, mouseY, dragTime));
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.bounds = new Bounds(this.y, this.x + this.width, this.y + this.height, this.x);
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public Screen getParentScreen() {
        return this.parentScreen;
    }
}

