/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.screens;

import com.wjbaker.ccm.gui.screens.IScreen;
import com.wjbaker.ccm.render.RenderManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class ScreenWrapper
extends Screen
implements IScreen {
    private boolean isMouseDown;
    private long mouseDragTime;

    public ScreenWrapper() {
        super((ITextComponent)new StringTextComponent(""));
    }

    public void tick() {
        this.updateScreen();
        if (this.isMouseDown) {
            ++this.mouseDragTime;
        }
        super.tick();
    }

    public void render(int mouseX, int mouseY, float delta) {
        RenderManager.pre();
        this.drawScreen(mouseX, mouseY);
        RenderManager.post();
        super.render(mouseX, mouseY, delta);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.onMouseDown((int)mouseX, (int)mouseY, button);
        this.isMouseDown = true;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.onMouseUp((int)mouseX, (int)mouseY, button);
        this.isMouseDown = false;
        this.mouseDragTime = 0L;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.onMouseMove((int)mouseX, (int)mouseY);
        super.func_212927_b(mouseX, mouseY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.onMouseDrag((int)mouseX, (int)mouseY, (int)(mouseX + deltaX), (int)(mouseY + deltaY), this.mouseDragTime);
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        if (amount > 0.0) {
            this.onMouseScrollUp();
        } else if (amount < 0.0) {
            this.onMouseScrollDown();
        }
        return super.mouseScrolled(mouseX, mouseY, amount);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        this.onKeyDown(keyCode, modifiers);
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        this.onKeyUp(keyCode, modifiers);
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }
}

