/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.render;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.object.RGBA;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1296;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_239;
import net.minecraft.class_310;

public class ComputedProperties {
    private final class_310 mc;
    private final CustomCrosshair crosshair;
    private final int gap;
    private final RGBA colour;
    private final boolean doRender;
    private final Map<class_1792, Float> usageItems = ImmutableMap.of((Object)class_1802.field_8102, (Object)Float.valueOf(20.0f), (Object)class_1802.field_8547, (Object)Float.valueOf(10.0f), (Object)class_1802.field_8399, (Object)Float.valueOf(0.0f));
    private final Set<class_1792> attackableItems = ImmutableSet.of((Object)class_1802.field_8091, (Object)class_1802.field_8845, (Object)class_1802.field_8528, (Object)class_1802.field_8371, (Object)class_1802.field_8802, (Object)class_1802.field_22022, (Object[])new class_1792[]{class_1802.field_8406, class_1802.field_8825, class_1802.field_8062, class_1802.field_8475, class_1802.field_8556, class_1802.field_22025, class_1802.field_8876, class_1802.field_8322, class_1802.field_8776, class_1802.field_8699, class_1802.field_8250, class_1802.field_22023, class_1802.field_8647, class_1802.field_8335, class_1802.field_8387, class_1802.field_8403, class_1802.field_8377, class_1802.field_22024, class_1802.field_8167, class_1802.field_8303, class_1802.field_8431, class_1802.field_8609, class_1802.field_8527, class_1802.field_22026, class_1802.field_8547});

    public ComputedProperties(CustomCrosshair crosshair) {
        this.mc = class_310.method_1551();
        this.crosshair = crosshair;
        this.gap = this.computeGap();
        this.colour = this.computeColour();
        this.doRender = this.computeDoRender();
    }

    public int getGap() {
        return this.gap;
    }

    private int computeGap() {
        int originalGap = this.crosshair.getPropertyValue("crosshair_gap", Integer.class);
        if (this.mc.field_1724 == null) {
            return originalGap;
        }
        boolean isSpectator = this.mc.field_1724.method_7325();
        boolean isHoldingItem = !this.mc.field_1724.method_5998(class_1268.field_5810).method_7960() || !this.mc.field_1724.method_5998(class_1268.field_5808).method_7960();
        boolean dynamicBowEnabled = this.crosshair.getPropertyValue("dynamic_bow_enabled", Boolean.class);
        boolean dynamicAttackIndicatorEnabled = this.crosshair.getPropertyValue("dynamic_attackindicator_enabled", Boolean.class);
        if (!isSpectator && isHoldingItem && (dynamicAttackIndicatorEnabled || dynamicBowEnabled)) {
            float gapModifier = 2.0f;
            Float usageItem = this.usageItems.get(this.mc.field_1724.method_6030().method_7909());
            if (dynamicBowEnabled && usageItem != null) {
                if (this.mc.field_1724.method_6030().method_7909() == class_1802.field_8399) {
                    usageItem = Float.valueOf(class_1764.method_7775((class_1799)this.mc.field_1724.method_6030()));
                }
                float progress = Math.min(usageItem.floatValue(), (float)this.mc.field_1724.method_6048());
                return originalGap + Math.round((usageItem.floatValue() - progress) * gapModifier);
            }
            if (dynamicAttackIndicatorEnabled && this.attackableItems.contains(this.mc.field_1724.method_6047().method_7909())) {
                float currentAttackUsage = this.mc.field_1724.method_7261(1.0f);
                float maxAttackUsage = 1.0f;
                if (this.mc.field_1724.method_7279() > 5.0f && currentAttackUsage < maxAttackUsage) {
                    return originalGap + Math.round((maxAttackUsage - currentAttackUsage) * gapModifier * 20.0f);
                }
            }
        }
        return originalGap;
    }

    public RGBA getColour() {
        return this.colour;
    }

    private RGBA computeColour() {
        RGBA originalColour = this.crosshair.getPropertyValue("crosshair_colour", RGBA.class);
        if (this.mc.field_1765 == null || this.mc.field_1765.method_17783() != class_239.class_240.field_1331) {
            if (this.crosshair.getPropertyValue("rainbow_enabled", Boolean.class).booleanValue()) {
                return this.getRainbowColour();
            }
            return originalColour;
        }
        boolean isHighlightPlayerEnabled = this.crosshair.getPropertyValue("highlight_players_enabled", Boolean.class);
        if (isHighlightPlayerEnabled && this.mc.field_1692 instanceof class_1657) {
            return this.crosshair.getPropertyValue("highlight_players_colour", RGBA.class);
        }
        boolean isHighlightHostileEnabled = this.crosshair.getPropertyValue("highlight_hostile_enabled", Boolean.class);
        if (isHighlightHostileEnabled && this.mc.field_1692 instanceof class_1588) {
            return this.crosshair.getPropertyValue("highlight_hostile_colour", RGBA.class);
        }
        boolean isHighlightPassiveEnabled = this.crosshair.getPropertyValue("highlight_passive_enabled", Boolean.class);
        if (isHighlightPassiveEnabled && this.mc.field_1692 instanceof class_1296) {
            return this.crosshair.getPropertyValue("highlight_passive_colour", RGBA.class);
        }
        return originalColour;
    }

    private RGBA getRainbowColour() {
        ++this.crosshair.rainbowTicks;
        if (this.crosshair.rainbowTicks > 125000) {
            this.crosshair.rainbowTicks = 0;
        }
        int opacity = this.crosshair.getPropertyValue("crosshair_colour", RGBA.class).getOpacity();
        return new RGBA(255, 255, 255, opacity).setRed(this.getRainbowColourComponent(0.0f)).setGreen(this.getRainbowColourComponent(2.0f)).setBlue(this.getRainbowColourComponent(4.0f));
    }

    private int getRainbowColourComponent(float offset) {
        int speed = this.crosshair.getPropertyValue("rainbow_speed", Integer.class);
        return (int)(Math.sin((float)(this.crosshair.rainbowTicks * speed) / 20000.0f + offset) * 127.0 + 128.0);
    }

    public boolean doRender() {
        return this.doRender;
    }

    private boolean computeDoRender() {
        boolean enabled = this.crosshair.getPropertyValue("mod_enabled", Boolean.class);
        boolean visibleDefault = this.visibleDefault();
        boolean visibleDebug = this.visibleDebug();
        boolean visibleThirdPerson = this.visibleThirdPerson();
        boolean visibleHiddenGUI = this.visibleHiddenGUI();
        boolean visibleSpectator = this.visibleSpectator();
        return enabled && (visibleDefault || visibleDebug || visibleThirdPerson || visibleHiddenGUI || visibleSpectator);
    }

    private boolean visibleDefault() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_default", Boolean.class);
        return !this.mc.field_1690.field_1866 && this.mc.field_1690.field_1850 == 0 && !this.mc.field_1690.field_1842 && this.mc.field_1724 != null && !this.mc.field_1724.method_7325() && propertyValue;
    }

    private boolean visibleDebug() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_debug", Boolean.class);
        return this.mc.field_1690.field_1866 && propertyValue;
    }

    private boolean visibleThirdPerson() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_thirdperson", Boolean.class);
        return this.mc.field_1690.field_1850 > 0 && propertyValue;
    }

    private boolean visibleHiddenGUI() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_hiddengui", Boolean.class);
        return this.mc.field_1690.field_1842 && propertyValue;
    }

    private boolean visibleSpectator() {
        boolean propertyValue = this.crosshair.getPropertyValue("visible_spectator", Boolean.class);
        return this.mc.field_1724 != null && this.mc.field_1724.method_7325() && propertyValue;
    }
}

