/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.crosshair.style;

import com.wjbaker.ccm.crosshair.CustomCrosshair;
import com.wjbaker.ccm.crosshair.render.ComputedProperties;
import com.wjbaker.ccm.crosshair.style.CrosshairStyle;
import com.wjbaker.ccm.object.Points;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;

public class CrossStyle
extends CrosshairStyle {
    public CrossStyle() {
        super("Cross");
    }

    @Override
    public void draw(CustomCrosshair crosshair, ComputedProperties computedProperties, int x, int y) {
        if (!computedProperties.doRender()) {
            return;
        }
        boolean outlineEnabled = crosshair.getPropertyValue("outline_enabled", Boolean.class);
        float thickness = (float)crosshair.getPropertyValue("crosshair_thickness", Integer.class).intValue() / 2.0f;
        int width = crosshair.getPropertyValue("crosshair_width", Integer.class);
        int height = crosshair.getPropertyValue("crosshair_height", Integer.class);
        if (outlineEnabled) {
            this.drawOutline(crosshair, x, y, computedProperties.getGap(), width, height, thickness);
        }
        this.drawBars(x, y, computedProperties.getGap(), width, height, thickness, computedProperties.getColour());
    }

    private void drawBars(int x, int y, int renderGap, int width, int height, float thickness, RGBA renderColour) {
        RenderManager.drawFilledRectangle((float)x - thickness, y - renderGap - height, (float)x + thickness, y - renderGap, renderColour, true);
        RenderManager.drawFilledRectangle((float)x - thickness, y + renderGap, (float)x + thickness, y + renderGap + height, renderColour, true);
        RenderManager.drawFilledRectangle(x - renderGap - width, (float)y - thickness, x - renderGap, (float)y + thickness, renderColour, true);
        RenderManager.drawFilledRectangle(x + renderGap, (float)y - thickness, x + renderGap + width, (float)y + thickness, renderColour, true);
    }

    private void drawOutline(CustomCrosshair crosshair, int x, int y, int renderGap, int width, int height, float thickness) {
        RGBA outlineColour = crosshair.getPropertyValue("outline_colour", RGBA.class);
        Points top = new Points((float)x - thickness - 0.5f, (float)(y - renderGap - height) - 0.5f, (float)x - thickness - 0.5f, (float)(y - renderGap) + 0.5f, (float)x - thickness - 0.5f, (float)(y - renderGap) + 0.5f, (float)x + thickness + 0.5f, (float)(y - renderGap) + 0.5f, (float)x + thickness + 0.5f, (float)(y - renderGap) + 0.5f, (float)x + thickness + 0.5f, (float)(y - renderGap - height) - 0.5f, (float)x + thickness + 0.5f, (float)(y - renderGap - height) - 0.5f, (float)x - thickness - 0.5f, (float)(y - renderGap - height) - 0.5f);
        Points bottom = new Points((float)x - thickness - 0.5f, (float)(y + renderGap + height) + 0.5f, (float)x - thickness - 0.5f, (float)(y + renderGap) - 0.5f, (float)x - thickness - 0.5f, (float)(y + renderGap) - 0.5f, (float)x + thickness + 0.5f, (float)(y + renderGap) - 0.5f, (float)x + thickness + 0.5f, (float)(y + renderGap) - 0.5f, (float)x + thickness + 0.5f, (float)(y + renderGap + height) + 0.5f, (float)x + thickness + 0.5f, (float)(y + renderGap + height) + 0.5f, (float)x - thickness - 0.5f, (float)(y + renderGap + height) + 0.5f);
        Points right = new Points((float)(x + renderGap + width) + 0.5f, (float)y - thickness - 0.5f, (float)(x + renderGap + width) + 0.5f, (float)y + thickness + 0.5f, (float)(x + renderGap + width) + 0.5f, (float)y + thickness + 0.5f, (float)(x + renderGap) - 0.5f, (float)y + thickness + 0.5f, (float)(x + renderGap) - 0.5f, (float)y + thickness + 0.5f, (float)(x + renderGap) - 0.5f, (float)y - thickness - 0.5f, (float)(x + renderGap) - 0.5f, (float)y - thickness - 0.5f, (float)(x + renderGap + width) + 0.5f, (float)y - thickness - 0.5f);
        Points left = new Points((float)(x - renderGap - width) - 0.5f, (float)y - thickness - 0.5f, (float)(x - renderGap - width) - 0.5f, (float)y + thickness + 0.5f, (float)(x - renderGap - width) - 0.5f, (float)y + thickness + 0.5f, (float)(x - renderGap) + 0.5f, (float)y + thickness + 0.5f, (float)(x - renderGap) + 0.5f, (float)y + thickness + 0.5f, (float)(x - renderGap) + 0.5f, (float)y - thickness - 0.5f, (float)(x - renderGap) + 0.5f, (float)y - thickness - 0.5f, (float)(x - renderGap - width) - 0.5f, (float)y - thickness - 0.5f);
        float outlineThickness = 2.0f;
        RenderManager.drawLines(top, outlineThickness, outlineColour, true);
        RenderManager.drawLines(bottom, outlineThickness, outlineColour, true);
        RenderManager.drawLines(right, outlineThickness, outlineColour, true);
        RenderManager.drawLines(left, outlineThickness, outlineColour, true);
    }
}

