/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.components;

import com.wjbaker.ccm.gui.GuiTheme;
import com.wjbaker.ccm.gui.components.Component;
import com.wjbaker.ccm.gui.screens.Screen;
import com.wjbaker.ccm.render.RenderManager;

public class Panel
extends Component {
    protected int xOffset;
    protected int yOffset;
    private int componentsHeight;
    protected int componentSpacing;
    private Orientation orientation;

    public Panel(Screen parentScreen, int x, int y, int width, int height) {
        super(parentScreen, "", x, y, width, height);
        this.hoverBorderColour = this.borderColour = GuiTheme.DARK_GREY;
        this.backgroundColour = GuiTheme.TRANSPARENT;
        this.hoverBackgroundColour = GuiTheme.TRANSPARENT;
        this.xOffset = 7;
        this.yOffset = 7;
        this.componentsHeight = 0;
        this.componentSpacing = 5;
        this.currentBackgroundColour = this.backgroundColour;
        this.currentBorderColour = this.borderColour;
        this.orientation = Orientation.VERTICAL;
    }

    @Override
    public void drawComponent() {
        RenderManager.drawBorderedRectangle(this.x, this.y, this.x + this.width, this.y + this.height, 1.0f, this.currentBorderColour, this.currentBackgroundColour, true);
        this.drawComponents();
    }

    private void drawComponents() {
        switch (this.orientation) {
            case HORIZONTAL: {
                this.drawHorizontally();
                break;
            }
            case VERTICAL: {
                this.drawVertically();
            }
        }
    }

    private void drawVertically() {
        int height = this.y + this.yOffset;
        for (Component component : this.components) {
            component.setPosition(this.x + this.xOffset, height);
            height += component.height + this.componentSpacing;
            component.drawComponent();
        }
    }

    private void drawHorizontally() {
        int width = this.x + this.xOffset;
        for (Component component : this.components) {
            component.setPosition(width, this.y + this.yOffset);
            width += component.width + this.componentSpacing;
            component.drawComponent();
        }
    }

    public void addComponent(Component component) {
        this.components.add(component);
    }

    public void removeComponent(Component component) {
        this.components.remove(component);
    }

    public void packComponent() {
        switch (this.orientation) {
            case HORIZONTAL: {
                this.packHorizontal();
                break;
            }
            case VERTICAL: {
                this.packVertical();
            }
        }
    }

    private void packVertical() {
        int height = this.yOffset + this.yOffset;
        for (Component component : this.components) {
            height += component.height + this.componentSpacing;
        }
        if (this.components.size() > 0) {
            height -= this.componentSpacing;
        }
        this.height = height;
    }

    private void packHorizontal() {
        int width = this.xOffset + this.xOffset;
        for (Component component : this.components) {
            width += component.width + this.componentSpacing;
        }
        if (this.components.size() > 0) {
            width -= this.componentSpacing;
        }
        this.width = width;
        for (Component component : this.components) {
            this.height = Math.max(this.height, component.height);
        }
        this.height += this.yOffset * 2;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public void setXOffset(int xOffset) {
        this.xOffset = xOffset;
    }

    public static enum Orientation {
        VERTICAL,
        HORIZONTAL;

    }
}

