/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.config;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.crosshair.property.Property;
import com.wjbaker.ccm.crosshair.property.PropertyConverter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public abstract class CrosshairConfig {
    private static final String SAVE_LOCATION = "crosshair_config.ccmcfg";
    private static final String COMMENT = "#";
    private static final String[] HEADER = new String[]{String.format("%s %s v%s", "#", "Custom Crosshair Mod", "1.0.2-forge"), String.format("%s Made by Sparkless101", "#"), String.format("%s ------------------------------------", "#"), String.format("%s %s", "#", "https://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/2637819/"), String.format("%s %s", "#", "https://www.curseforge.com/projects/242995/"), String.format("%s ------------------------------------", "#"), String.format("%s This config file contains the properties of the crosshair and mod properties. Feel free to edit them.", "#"), String.format("%s ------------------------------------", "#")};

    private CrosshairConfig() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean readFromFile() {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(SAVE_LOCATION));){
            String currentLine = null;
            while ((currentLine = bufferedReader.readLine()) != null) {
                String[] lineSplit;
                if (currentLine.startsWith(COMMENT) || (lineSplit = currentLine.split(":")).length == 0) continue;
                String alias = lineSplit[0].trim().toLowerCase();
                String value = lineSplit[1].trim().toLowerCase();
                Property property = CustomCrosshairMod.CROSSHAIR.getProperty(alias);
                if (property == null) continue;
                Object newValue = PropertyConverter.convertToType(value, property.getType());
                if (newValue != null) {
                    CustomCrosshairMod.CROSSHAIR.setPropertyValue(alias, newValue);
                }
                CustomCrosshairMod.log("[Config] Setting Property {} to {}", alias, value);
            }
            CustomCrosshairMod.log("[Config] Finished reading config from file.", new Object[0]);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeToFile() {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(SAVE_LOCATION));){
            for (String line : HEADER) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            for (Map.Entry entry : CustomCrosshairMod.CROSSHAIR.getProperties()) {
                bufferedWriter.write(String.format("%s:%s", entry.getKey(), entry.getValue()));
                bufferedWriter.newLine();
            }
            CustomCrosshairMod.log("[Config] Finished writing config to file.", new Object[0]);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

