/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.gui.components;

import com.wjbaker.ccm.CustomCrosshairMod;
import com.wjbaker.ccm.gui.GuiTheme;
import com.wjbaker.ccm.gui.components.Component;
import com.wjbaker.ccm.gui.screens.Screen;
import com.wjbaker.ccm.object.RGBA;
import com.wjbaker.ccm.render.RenderManager;

public class Slider
extends Component {
    private int thumbPosition = 0;
    private boolean isMouseOverThumb = false;
    private boolean isDragging = false;
    private int thumbSize = 10;
    private int grabOffset = 0;
    private RGBA currentThumbBackgroundColour;
    private RGBA thumbBackgroundColour = GuiTheme.PRIMARY;
    private RGBA thumbHoverBackgroundColour = GuiTheme.SECONDARY;
    private float value;
    private float minValue;
    private float maxValue;
    private ValueType valueType;

    public Slider(Screen parentScreen, String label, int x, int y, int width, int minValue, int maxValue) {
        super(parentScreen, label, x, y, width, 26);
        this.currentThumbBackgroundColour = this.thumbBackgroundColour;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueType = ValueType.INTEGER;
        this.hoverBackgroundColour = this.backgroundColour;
    }

    @Override
    public void drawComponent() {
        RenderManager.drawString(this.label, this.x, this.y + 2, this.currentTextColour);
        RenderManager.drawBorderedRectangle(this.x, this.y + 11 + 3 + this.thumbSize / 2 - 1, this.x + this.width, this.y + 11 + 3 + this.thumbSize / 2 + 1, 1.0f, this.currentBorderColour, this.currentBackgroundColour, true);
        RenderManager.drawBorderedRectangle(this.x + this.thumbPosition, this.y + 11 + 3, this.x + this.thumbPosition + this.thumbSize, this.y + 11 + 3 + this.thumbSize, 1.0f, GuiTheme.DARK_GREY, this.currentThumbBackgroundColour, true);
        RenderManager.drawString(this.getDisplayValue(this.value), this.x + this.width + 5, this.y + 11 + 3 + this.thumbSize / 2 - 4, this.currentTextColour);
    }

    @Override
    public void onMouseDrag(int startX, int startY, int mouseX, int mouseY, long dragTime) {
        if (this.isDragging) {
            this.setThumbPosition(mouseX);
            this.setValue();
        }
    }

    private void setThumbPosition(int mouseX) {
        int newScrollValue = mouseX - this.x - this.grabOffset;
        int maxWidth = this.width - this.thumbSize;
        if (newScrollValue < 0) {
            newScrollValue = 0;
        }
        if (newScrollValue > maxWidth) {
            newScrollValue = maxWidth;
        }
        this.thumbPosition = newScrollValue;
    }

    private void setValue() {
        float scrollRatio = (float)this.thumbPosition / (float)(this.width - this.thumbSize);
        this.value = this.minValue + (this.maxValue - this.minValue) * scrollRatio;
        if (this.boundProperty != null) {
            if (this.valueType == ValueType.FLOAT) {
                CustomCrosshairMod.CROSSHAIR.setPropertyValue(this.boundProperty, Float.valueOf(this.value));
            } else {
                CustomCrosshairMod.CROSSHAIR.setPropertyValue(this.boundProperty, this.valueToInt());
            }
        }
    }

    public void setValue(float value) {
        this.value = value;
        this.updateThumbPosition();
    }

    private void updateThumbPosition() {
        this.thumbPosition = (int)((float)(this.width - this.thumbSize) * ((this.value - this.minValue) / (this.maxValue - this.minValue)));
    }

    @Override
    public void bindProperty(String property) {
        super.bindProperty(property);
        Class<?> clazz = CustomCrosshairMod.CROSSHAIR.getProperty(this.boundProperty).getType();
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            this.value = CustomCrosshairMod.CROSSHAIR.getPropertyValue(this.boundProperty, Integer.class).intValue();
        } else if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            this.value = CustomCrosshairMod.CROSSHAIR.getPropertyValue(this.boundProperty, Float.class).floatValue();
        }
        this.updateThumbPosition();
    }

    @Override
    public void onMouseDown(int mouseX, int mouseY) {
        if (this.isOverThumb(mouseX, mouseY)) {
            this.isDragging = true;
            this.grabOffset = mouseX - this.thumbPosition - this.thumbSize - 3;
        }
    }

    @Override
    public void onMouseUp(int mouseX, int mouseY) {
        this.isDragging = false;
        this.updateThumbPosition();
    }

    @Override
    public void onMouseMove(int mouseX, int mouseY) {
        boolean isMouseOverThumb = this.isOverThumb(mouseX, mouseY);
        if (this.isMouseOverThumb != isMouseOverThumb) {
            this.currentThumbBackgroundColour = isMouseOverThumb ? this.thumbHoverBackgroundColour : this.thumbBackgroundColour;
            this.isMouseOverThumb = isMouseOverThumb;
        }
    }

    public void setThumbColours(RGBA background, RGBA hoverBackground) {
        this.thumbBackgroundColour = background;
        this.thumbHoverBackgroundColour = hoverBackground;
        this.currentThumbBackgroundColour = this.isMouseOverThumb ? this.thumbHoverBackgroundColour : this.thumbBackgroundColour;
    }

    @Override
    public void onMouseLeave() {
        super.onMouseLeave();
        this.isDragging = false;
    }

    private boolean isOverThumb(int mouseX, int mouseY) {
        return mouseX > this.x + this.thumbPosition && mouseX < this.x + this.thumbPosition + this.thumbSize && mouseY > this.y + 11 + 3 && mouseY < this.y + 11 + 3 + this.thumbSize;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    private String getFormattedValue() {
        if (this.valueType == ValueType.FLOAT) {
            return String.format("%.2f", Float.valueOf(this.value));
        }
        return String.valueOf(this.valueToInt());
    }

    protected String getDisplayValue(float value) {
        return this.getFormattedValue();
    }

    protected int valueToInt() {
        return Math.round(this.value);
    }

    public int getValue() {
        return this.valueToInt();
    }

    public static enum ValueType {
        FLOAT,
        INTEGER;

    }
}

