/*
 * Decompiled with CFR 0.152.
 */
package com.wjbaker.ccm.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.wjbaker.ccm.object.Points;
import com.wjbaker.ccm.object.RGBA;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public abstract class RenderManager {
    private RenderManager() {
    }

    public static void pre() {
        GL11.glPushMatrix();
    }

    public static void post() {
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
        GL11.glPopMatrix();
    }

    private static void toggleProperty(int property, boolean enable) {
        if (enable) {
            GL11.glEnable((int)property);
        } else {
            GL11.glDisable((int)property);
        }
    }

    public static void colour(RGBA colour) {
        GL11.glColor4f((float)((float)colour.getRed() / 255.0f), (float)((float)colour.getGreen() / 255.0f), (float)((float)colour.getBlue() / 255.0f), (float)((float)colour.getOpacity() / 255.0f));
    }

    public static void drawLines(Points _points, float thickness, RGBA colour, boolean smooth) {
        RenderManager.toggleProperty(2848, smooth);
        RenderManager.colour(colour);
        GL11.glLineWidth((float)thickness);
        float[] points = _points.get();
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.func_225582_a_((double)points[i], (double)points[i + 1], 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawLine(float x1, float y1, float x2, float y2, float thickness, RGBA colour, boolean smooth) {
        RenderManager.drawLines(new Points(x1, y1, x2, y2), thickness, colour, smooth);
    }

    public static void drawRectangle(float x1, float y1, float x2, float y2, float thickness, RGBA colour, boolean smooth) {
        Points points = new Points(x1, y1, x2, y1, x2, y1, x2, y2, x1, y2, x2, y2, x1, y1, x1, y2);
        RenderManager.drawLines(points, thickness, colour, smooth);
    }

    public static void drawFilledShape(Points _points, RGBA colour, boolean smooth) {
        RenderManager.toggleProperty(2848, smooth);
        float[] points = _points.get();
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(9, DefaultVertexFormats.field_181706_f);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < points.length; i += 2) {
            bufferBuilder.func_225582_a_((double)points[i], (double)points[i + 1], 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawFilledRectangle(float x1, float y1, float x2, float y2, RGBA colour, boolean smooth) {
        Points points = new Points(x1, y1, x1, y2, x2, y2, x2, y1);
        RenderManager.drawFilledShape(points, colour, smooth);
    }

    public static void drawBorderedRectangle(float x1, float y1, float x2, float y2, float borderThickness, RGBA borderColour, RGBA fillColour, boolean smooth) {
        RenderManager.drawFilledRectangle(x1, y1, x2, y2, fillColour, smooth);
        RenderManager.drawRectangle(x1, y1, x2, y2, borderThickness, borderColour, smooth);
    }

    public static void drawPartialCircle(float x, float y, float radius, int _startAngle, int _endAngle, float thickness, RGBA colour, boolean smooth) {
        RenderManager.toggleProperty(2848, smooth);
        int startAngle = Math.max(0, Math.min(_startAngle, _endAngle));
        int endAngle = Math.min(360, Math.max(_startAngle, _endAngle));
        GL11.glLineWidth((float)thickness);
        float ratio = (float)Math.PI / 180;
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        for (int i = startAngle; i <= endAngle; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.func_225582_a_((double)(x + (float)Math.cos(radians) * radius), (double)(y + (float)Math.sin(radians) * radius), 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawCircle(float x, float y, float radius, float thickness, RGBA colour, boolean smooth) {
        RenderManager.drawPartialCircle(x, y, radius, 0, 360, thickness, colour, smooth);
    }

    public static void drawTorus(int x, int y, int innerRadius, int outerRadius, RGBA colour, boolean smooth) {
        RenderManager.toggleProperty(2848, smooth);
        RenderManager.colour(colour);
        float ratio = (float)Math.PI / 180;
        float r = (float)colour.getRed() / 255.0f;
        float g = (float)colour.getGreen() / 255.0f;
        float b = (float)colour.getBlue() / 255.0f;
        float a = (float)colour.getOpacity() / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i <= 360; ++i) {
            float radians = (float)(i - 90) * ratio;
            bufferBuilder.func_225582_a_((double)((float)x + (float)Math.cos(radians) * (float)innerRadius), (double)((float)y + (float)Math.sin(radians) * (float)innerRadius), 0.0).func_227885_a_(r, g, b, a).func_181675_d();
            bufferBuilder.func_225582_a_((double)((float)x + (float)Math.cos(radians) * (float)outerRadius), (double)((float)y + (float)Math.sin(radians) * (float)outerRadius), 0.0).func_227885_a_(r, g, b, a).func_181675_d();
        }
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawString(String text, int x, int y, int colour) {
        Minecraft.func_71410_x().field_71466_p.func_238421_b_(new MatrixStack(), text, (float)x, (float)y, colour);
    }

    public static void drawStringWidthShadow(String text, int x, int y, int colour) {
        Minecraft.func_71410_x().field_71466_p.func_238405_a_(new MatrixStack(), text, (float)x, (float)y, colour);
    }

    public static int getStringWidth(String text) {
        return Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
    }
}

