/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.buildershape;

public enum StructureBuilderType {
    FACING,
    SQUARE,
    CIRCLE,
    SOLID,
    SPHERE,
    DIAGONAL,
    DOME,
    CUP,
    PYRAMID,
    CIRCLEVERTICAL;

    public static final StructureBuilderType[] SORTED;

    public static StructureBuilderType getNextType(StructureBuilderType btype) {
        int type = btype.ordinal();
        if (++type > SPHERE.ordinal()) {
            type = FACING.ordinal();
        }
        return StructureBuilderType.values()[type];
    }

    public boolean hasHeight() {
        return this != SPHERE && this != DIAGONAL && this != DOME && this != CUP;
    }

    public String shortcode() {
        switch (this) {
            case CIRCLE: {
                return "CH";
            }
            case DIAGONAL: {
                return "DI";
            }
            case FACING: {
                return "WA";
            }
            case SOLID: {
                return "SO";
            }
            case SPHERE: {
                return "SP";
            }
            case SQUARE: {
                return "SQ";
            }
            case DOME: {
                return "DO";
            }
            case CUP: {
                return "CU";
            }
            case PYRAMID: {
                return "PY";
            }
            case CIRCLEVERTICAL: {
                return "CV";
            }
        }
        return "";
    }

    static {
        SORTED = new StructureBuilderType[]{FACING, SQUARE, SOLID, DIAGONAL, PYRAMID, CIRCLE, CIRCLEVERTICAL, SPHERE, DOME, CUP};
    }
}

