/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.fan;

import com.lothrazar.cyclicmagic.block.core.TileEntityBaseMachineInvo;
import com.lothrazar.cyclicmagic.block.fan.BlockFan;
import com.lothrazar.cyclicmagic.data.ITilePreviewToggle;
import com.lothrazar.cyclicmagic.data.ITileRedstoneToggle;
import com.lothrazar.cyclicmagic.registry.SoundRegistry;
import com.lothrazar.cyclicmagic.util.UtilParticle;
import com.lothrazar.cyclicmagic.util.UtilShape;
import com.lothrazar.cyclicmagic.util.UtilSound;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityFan
extends TileEntityBaseMachineInvo
implements ITickable,
ITileRedstoneToggle,
ITilePreviewToggle {
    private static final int MIN_RANGE = 1;
    public static final int MAX_SPEED = 10;
    public static final int MAX_RANGE = 32;
    private static final String NBT_PUSH = "pushpull";
    private static final String NBT_RANGE = "range";
    private int timer;
    private int pushIfZero = 0;
    private int range = 16;
    private int isSilent;

    public TileEntityFan() {
        super(0);
        this.needsRedstone = 1;
        this.speed = 5;
    }

    @Override
    public int[] getFieldOrdinals() {
        return super.getFieldArray(Fields.values().length);
    }

    public void func_73660_a() {
        if (!this.isRunning()) {
            this.setAnimation(false);
            this.soundsOff();
            this.timer = 0;
            return;
        }
        this.particles();
        this.soundsOnAndLoop();
        this.setAnimation(true);
        this.tick();
        this.pushEntities();
    }

    private void soundsOff() {
        if (this.isSilent == 0 && this.timer != 0 && this.timer > 30) {
            UtilSound.playSound(this.func_145831_w(), this.func_174877_v(), SoundRegistry.fan_off, SoundCategory.BLOCKS, 1.0f);
        }
    }

    private void soundsOnAndLoop() {
        if (this.isSilent == 0) {
            int lengthOn = 31;
            int lengthLoop = 40;
            if (this.timer == 0) {
                UtilSound.playSound(this.func_145831_w(), this.func_174877_v(), SoundRegistry.fan_on, SoundCategory.BLOCKS, 0.8f);
            } else if (this.timer == lengthOn || (this.timer - lengthOn) % lengthLoop == 0) {
                UtilSound.playSound(this.func_145831_w(), this.func_174877_v(), SoundRegistry.fan_loop, SoundCategory.BLOCKS, 0.4f);
            }
        }
    }

    private void tick() {
        ++this.timer;
        if (this.timer >= 0x7FFFFFFE) {
            this.timer = 0;
        }
    }

    private void particles() {
        if (this.timer % 10 == 0 && this.isPreviewVisible()) {
            this.doParticles();
        }
    }

    private void doParticles() {
        List<BlockPos> shape = this.getShape();
        for (BlockPos pos : shape) {
            UtilParticle.spawnParticle(this.func_145831_w(), EnumParticleTypes.CLOUD, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1);
        }
    }

    private void setAnimation(boolean lit) {
        this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockFan.IS_LIT, (Comparable)Boolean.valueOf(lit)));
    }

    @Override
    public List<BlockPos> getShape() {
        return UtilShape.line(this.func_174877_v(), this.getCurrentFacing(), this.getCurrentRange());
    }

    private int pushEntities() {
        List<BlockPos> shape = this.getShape();
        if (shape.size() == 0) {
            return 0;
        }
        BlockPos start = shape.get(0);
        BlockPos end = shape.get(shape.size() - 1);
        switch (this.getCurrentFacing().func_176740_k()) {
            case X: {
                end = end.func_177982_a(0, 0, 1);
                end = end.func_177982_a(0, 1, 0);
                break;
            }
            case Z: {
                end = end.func_177982_a(1, 0, 0);
                end = end.func_177982_a(0, 1, 0);
                break;
            }
            case Y: {
                start = start.func_177982_a(1, 0, 0);
                end = end.func_177982_a(0, 0, 1);
            }
        }
        EnumFacing face = this.getCurrentFacing();
        switch (face) {
            case NORTH: {
                start = start.func_177968_d();
                break;
            }
            case SOUTH: {
                end = end.func_177968_d();
                break;
            }
            case EAST: {
                end = end.func_177974_f();
                break;
            }
            case WEST: {
                start = start.func_177974_f();
                break;
            }
            case DOWN: {
                break;
            }
        }
        AxisAlignedBB region = new AxisAlignedBB(start, end);
        List entitiesFound = this.func_145831_w().func_72872_a(Entity.class, region);
        int moved = 0;
        boolean doPush = this.pushIfZero == 0;
        int direction = 1;
        float SPEED = this.getSpeedCalc();
        for (Entity entity : entitiesFound) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_70093_af()) continue;
            ++moved;
            switch (face) {
                case NORTH: {
                    direction = !doPush ? 1 : -1;
                    entity.field_70179_y += (double)((float)direction * SPEED);
                    break;
                }
                case SOUTH: {
                    direction = doPush ? 1 : -1;
                    entity.field_70179_y += (double)((float)direction * SPEED);
                    break;
                }
                case EAST: {
                    direction = doPush ? 1 : -1;
                    entity.field_70159_w += (double)((float)direction * SPEED);
                    break;
                }
                case WEST: {
                    direction = !doPush ? 1 : -1;
                    entity.field_70159_w += (double)((float)direction * SPEED);
                    break;
                }
                case DOWN: {
                    direction = !doPush ? 1 : -1;
                    entity.field_70181_x += (double)((float)direction * SPEED);
                    break;
                }
                case UP: {
                    direction = doPush ? 1 : -1;
                    entity.field_70181_x += (double)((float)direction * SPEED);
                }
            }
        }
        return moved;
    }

    private float getSpeedCalc() {
        return (float)this.speed / 35.0f;
    }

    private int getCurrentRange() {
        EnumFacing facing = this.getCurrentFacing();
        for (int i = 1; i <= this.getRange(); ++i) {
            BlockPos tester = this.func_174877_v().func_177967_a(facing, i);
            if (this.canBlowThrough(tester)) continue;
            return i;
        }
        return this.getRange();
    }

    public int getRange() {
        return this.range;
    }

    private void setRange(int value) {
        this.range = Math.min(value, 32);
        if (this.range < 1) {
            this.range = 1;
        }
    }

    private boolean canBlowThrough(BlockPos tester) {
        return this.func_145831_w().func_175623_d(tester) || !this.func_145831_w().func_180495_p(tester).func_185913_b();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        tags.func_74768_a("Timer", this.timer);
        tags.func_74768_a("redstone", this.needsRedstone);
        tags.func_74768_a(NBT_PUSH, this.pushIfZero);
        tags.func_74768_a(NBT_RANGE, this.range);
        tags.func_74768_a("silent", this.isSilent);
        return super.func_189515_b(tags);
    }

    @Override
    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.timer = tags.func_74762_e("Timer");
        this.needsRedstone = tags.func_74762_e("redstone");
        this.pushIfZero = tags.func_74762_e(NBT_PUSH);
        this.range = tags.func_74762_e(NBT_RANGE);
        this.isSilent = tags.func_74762_e("silent");
    }

    @Override
    public void toggleNeedsRedstone() {
        int val = this.needsRedstone + 1;
        this.func_174885_b(Fields.REDSTONE.ordinal(), val % 2);
    }

    private void setPushPull(int value) {
        this.pushIfZero = value % 2;
        this.func_70296_d();
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
    }

    @Override
    public boolean onlyRunIfPowered() {
        return this.needsRedstone == 1;
    }

    @Override
    public int func_174890_g() {
        return Fields.values().length;
    }

    @Override
    public int func_174887_a_(int id) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    return this.timer;
                }
                case REDSTONE: {
                    return this.needsRedstone;
                }
                case PARTICLES: {
                    return this.renderParticles;
                }
                case PUSHPULL: {
                    return this.pushIfZero;
                }
                case RANGE: {
                    return this.range;
                }
                case SPEED: {
                    return this.speed;
                }
                case SILENT: {
                    return this.isSilent;
                }
            }
        }
        return -1;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id >= 0 && id < this.func_174890_g()) {
            switch (Fields.values()[id]) {
                case TIMER: {
                    this.timer = value;
                    break;
                }
                case REDSTONE: {
                    this.needsRedstone = value;
                    break;
                }
                case PARTICLES: {
                    this.renderParticles = value % 2;
                    break;
                }
                case PUSHPULL: {
                    this.setPushPull(value);
                    break;
                }
                case RANGE: {
                    this.setRange(value);
                    break;
                }
                case SPEED: {
                    this.setSpeed(value);
                    break;
                }
                case SILENT: {
                    this.isSilent = value % 2;
                }
            }
        }
    }

    @Override
    public void setSpeed(int value) {
        if (value < 1) {
            value = 1;
        }
        this.speed = Math.min(value, 10);
    }

    @Override
    public boolean isPreviewVisible() {
        return this.renderParticles == 1;
    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        PARTICLES,
        PUSHPULL,
        RANGE,
        SPEED,
        SILENT;

    }
}

