/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.util;

import com.lothrazar.cyclicmagic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;

public class UtilUncraft {
    public static boolean dictionaryFreedom;
    public static List<String> blacklistInput;
    public static List<String> blacklistOutput;
    public static List<String> blacklistMod;

    public static void resetBlacklists() {
        blacklistInput = new ArrayList<String>();
        blacklistOutput = new ArrayList<String>();
        blacklistMod = new ArrayList<String>();
    }

    public static void setBlacklist(String[] list, BlacklistType type) {
        if (list == null || list.length == 0) {
            return;
        }
        block5: for (String iname : list) {
            switch (type) {
                case MODNAME: {
                    blacklistMod.add(iname);
                    continue block5;
                }
                case INPUT: {
                    blacklistInput.add(iname);
                    continue block5;
                }
                case OUTPUT: {
                    blacklistOutput.add(iname);
                }
            }
        }
    }

    private static boolean isItemInBlacklist(ItemStack drop, BlacklistType type) {
        if (drop == null || drop.func_77973_b() == null) {
            return true;
        }
        return UtilUncraft.isItemInBlacklist(drop.func_77973_b(), type);
    }

    private static boolean isItemInBlacklist(Item item, BlacklistType type) {
        switch (type) {
            case INPUT: {
                String itemName = UtilItemStack.getStringForItem(item);
                for (String s : blacklistInput) {
                    if (s == null || !s.equals(itemName)) continue;
                    return true;
                }
            }
            case OUTPUT: {
                String itemName = UtilItemStack.getStringForItem(item);
                for (String s : blacklistOutput) {
                    if (s == null || !s.equals(itemName)) continue;
                    return true;
                }
            }
            case MODNAME: {
                String modId = item.getRegistryName().func_110624_b();
                for (String s : blacklistMod) {
                    if (s == null || !s.equals(modId)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    static {
        blacklistInput = new ArrayList<String>();
        blacklistOutput = new ArrayList<String>();
        blacklistMod = new ArrayList<String>();
    }

    public static class Uncrafter {
        private ArrayList<ItemStack> drops;
        private ItemStack toUncraft;
        private int outsize;
        private String errorString = "";

        private boolean isRemovedSinceContainerItem(ItemStack istack) {
            boolean hasContainerItem = istack.func_77973_b().getContainerItem(istack) != null;
            return hasContainerItem;
        }

        public ArrayList<ItemStack> getDrops() {
            return this.drops;
        }

        public int getOutsize() {
            return this.outsize;
        }

        private void tryAddOreDictionaryDrop(Object maybeOres) {
            if (maybeOres instanceof List && (List)maybeOres != null) {
                List ores = (List)maybeOres;
                if (ores.size() == 1) {
                    this.tryAddTrop((ItemStack)ores.get(0));
                } else if (ores.size() > 1 && dictionaryFreedom) {
                    this.tryAddTrop((ItemStack)ores.get(0));
                }
            }
        }

        private void tryAddTrop(ItemStack stackInput) {
            if (stackInput == null || stackInput.func_77973_b() == null) {
                return;
            }
            if (UtilUncraft.isItemInBlacklist(stackInput, BlacklistType.OUTPUT)) {
                return;
            }
            ItemStack stack = stackInput.func_77946_l();
            stack.func_190920_e(1);
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                if (dictionaryFreedom) {
                    stack.func_77964_b(0);
                } else {
                    return;
                }
            }
            if (!stack.func_190926_b()) {
                this.drops.add(stack);
            }
        }

        private boolean doesRecipeMatch(IRecipe r) {
            return r != null && r.func_77571_b() != null && this.doesRecipeInputMatch(r.func_77571_b());
        }

        private boolean doesRecipeInputMatch(ItemStack recipeOutput) {
            return UtilItemStack.isItemStackEqualIgnoreCount(recipeOutput, this.toUncraft);
        }

        public UncraftResultType process(ItemStack stuff) {
            this.toUncraft = stuff;
            this.drops = new ArrayList();
            this.outsize = 0;
            if (this.toUncraft == null || this.toUncraft.func_77973_b() == null) {
                return UncraftResultType.EMPTY;
            }
            if (UtilUncraft.isItemInBlacklist(this.toUncraft, BlacklistType.INPUT)) {
                return UncraftResultType.BLACKLIST;
            }
            if (UtilUncraft.isItemInBlacklist(this.toUncraft, BlacklistType.MODNAME)) {
                return UncraftResultType.BLACKLIST;
            }
            this.outsize = 0;
            UncraftResultType result = UncraftResultType.NORECIPE;
            for (IRecipe next : CraftingManager.field_193380_a) {
                boolean enchantingMatches;
                if (next == null || next.func_77571_b() == null || !this.doesRecipeMatch(next)) continue;
                boolean bl = enchantingMatches = next.func_77571_b().func_77948_v() == this.toUncraft.func_77948_v();
                if (!enchantingMatches) {
                    result = UncraftResultType.ENCHANTMATCH;
                    continue;
                }
                if (this.toUncraft.func_190916_E() < next.func_77571_b().func_190916_E()) {
                    result = UncraftResultType.NOTENOUGHITEMS;
                    continue;
                }
                this.outsize = next.func_77571_b().func_190916_E();
                List<ItemStack> input = this.getRecipeInput(next);
                if (input == null) {
                    result = UncraftResultType.UNKNOWN;
                    continue;
                }
                for (ItemStack maybeOres : input) {
                    if (maybeOres instanceof ItemStack) {
                        this.tryAddTrop(maybeOres);
                        continue;
                    }
                    this.tryAddOreDictionaryDrop(maybeOres);
                }
                result = UncraftResultType.SUCCESS;
                break;
            }
            return result;
        }

        private List<ItemStack> getRecipeInput(IRecipe next) {
            NonNullList ingreds = next.func_192400_c();
            ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
            for (Ingredient i : ingreds) {
                if (i == null || i.func_193365_a() == null || i.func_193365_a().length <= 0) continue;
                inputs.add(i.func_193365_a()[0]);
            }
            return inputs;
        }

        public String getErrorString() {
            return this.errorString;
        }

        public void setErrorString(String errorString) {
            this.errorString = errorString;
        }
    }

    public static enum UncraftResultType {
        BLACKLIST,
        NORECIPE,
        NOTENOUGHITEMS,
        SUCCESS,
        EMPTY,
        ENCHANTMATCH,
        UNKNOWN;

    }

    public static enum BlacklistType {
        INPUT,
        OUTPUT,
        MODNAME;

    }
}

