/*
 * Decompiled with CFR 0.152.
 */
package grondag.darkness;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.function.Function;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_2869;
import net.minecraft.class_2874;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import net.minecraft.class_757;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Darkness {
    public static Logger LOG;
    private static final boolean darkOverworld;
    private static final boolean darkDefault;
    private static final boolean darkNether;
    private static final double darkNetherFog;
    private static final boolean darkEnd;
    private static final double darkEndFog;
    private static final boolean darkSkyless;
    public static boolean enabled;
    private static final float[][] LUMINANCE;

    public static double darkNetherFog() {
        return darkNetherFog;
    }

    public static double darkEndFog() {
        return darkEndFog;
    }

    private static boolean isDark(class_1937 world) {
        class_2874 dimType = world.field_9247.method_12460();
        if (dimType == class_2874.field_13072) {
            return darkOverworld;
        }
        if (dimType == class_2874.field_13076) {
            return darkNether;
        }
        if (dimType == class_2874.field_13078) {
            return darkEnd;
        }
        if (world.field_9247.method_12451()) {
            return darkDefault;
        }
        return darkSkyless;
    }

    private static float skyFactor(class_1937 world) {
        if (Darkness.isDark(world)) {
            if (world.field_9247.method_12451()) {
                float angle = world.method_8400(0.0f);
                if (angle > 0.25f && angle < 0.75f) {
                    float oldWeight = Math.max(0.0f, Math.abs(angle - 0.5f) - 0.2f) * 20.0f;
                    float moon = world.method_8391();
                    return class_3532.method_16439((float)(oldWeight * oldWeight * oldWeight), (float)(moon * moon), (float)1.0f);
                }
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public static int darken(int c, int blockIndex, int skyIndex) {
        float lTarget = LUMINANCE[blockIndex][skyIndex];
        float r = (float)(c & 0xFF) / 255.0f;
        float g = (float)(c >> 8 & 0xFF) / 255.0f;
        float b = (float)(c >> 16 & 0xFF) / 255.0f;
        float l = Darkness.luminance(r, g, b);
        float f = l > 0.0f ? Math.min(1.0f, lTarget / l) : 0.0f;
        return f == 1.0f ? c : 0xFF000000 | Math.round(f * r * 255.0f) | Math.round(f * g * 255.0f) << 8 | Math.round(f * b * 255.0f) << 16;
    }

    public static float luminance(float r, float g, float b) {
        return r * 0.2126f + g * 0.7152f + b * 0.0722f;
    }

    public static void updateLuminance(float tickDelta, class_310 client, class_757 worldRenderer, float prevFlicker) {
        class_638 world = client.field_1687;
        if (world != null) {
            if (!Darkness.isDark((class_1937)world) || client.field_1724.method_6059(class_1294.field_5925) || client.field_1724.method_6059(class_1294.field_5927) && client.field_1724.method_3140() > 0.0f || world.method_23789() > 0) {
                enabled = false;
                return;
            }
            enabled = true;
            float dimSkyFactor = Darkness.skyFactor((class_1937)world);
            float ambient = world.method_23783(1.0f);
            class_2869 dim = world.field_9247;
            boolean blockAmbient = !Darkness.isDark((class_1937)world);
            for (int skyIndex = 0; skyIndex < 16; ++skyIndex) {
                float skyFactor = 1.0f - (float)skyIndex / 15.0f;
                skyFactor = 1.0f - skyFactor * skyFactor * skyFactor * skyFactor;
                float min = (skyFactor *= dimSkyFactor) * 0.05f;
                float rawAmbient = ambient * skyFactor;
                float minAmbient = rawAmbient * (1.0f - min) + min;
                float skyBase = dim.method_23759(skyIndex) * minAmbient;
                min = 0.35f * skyFactor;
                float skyRed = skyBase * (rawAmbient * (1.0f - min) + min);
                float skyGreen = skyBase * (rawAmbient * (1.0f - min) + min);
                float skyBlue = skyBase;
                if (worldRenderer.method_3195(tickDelta) > 0.0f) {
                    float skyDarkness = worldRenderer.method_3195(tickDelta);
                    skyRed = skyRed * (1.0f - skyDarkness) + skyRed * 0.7f * skyDarkness;
                    skyGreen = skyGreen * (1.0f - skyDarkness) + skyGreen * 0.6f * skyDarkness;
                    skyBlue = skyBlue * (1.0f - skyDarkness) + skyBlue * 0.6f * skyDarkness;
                }
                for (int blockIndex = 0; blockIndex < 16; ++blockIndex) {
                    float blockFactor = 1.0f;
                    if (!blockAmbient) {
                        blockFactor = 1.0f - (float)blockIndex / 15.0f;
                        blockFactor = 1.0f - blockFactor * blockFactor * blockFactor * blockFactor;
                    }
                    float blockBase = blockFactor * dim.method_23759(blockIndex) * (prevFlicker * 0.1f + 1.5f);
                    min = 0.4f * blockFactor;
                    float blockGreen = blockBase * ((blockBase * (1.0f - min) + min) * (1.0f - min) + min);
                    float blockBlue = blockBase * (blockBase * blockBase * (1.0f - min) + min);
                    float red = skyRed + blockBase;
                    float green = skyGreen + blockGreen;
                    float blue = skyBlue + blockBlue;
                    float f = Math.max(skyFactor, blockFactor);
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (world.field_9247.method_12460() == class_2874.field_13078) {
                        red = skyFactor * 0.22f + blockBase * 0.75f;
                        green = skyFactor * 0.28f + blockGreen * 0.75f;
                        blue = skyFactor * 0.25f + blockBlue * 0.75f;
                    }
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    float gamma = (float)client.field_1690.field_1840 * f;
                    float invRed = 1.0f - red;
                    float invGreen = 1.0f - green;
                    float invBlue = 1.0f - blue;
                    invRed = 1.0f - invRed * invRed * invRed * invRed;
                    invGreen = 1.0f - invGreen * invGreen * invGreen * invGreen;
                    invBlue = 1.0f - invBlue * invBlue * invBlue * invBlue;
                    red = red * (1.0f - gamma) + invRed * gamma;
                    green = green * (1.0f - gamma) + invGreen * gamma;
                    blue = blue * (1.0f - gamma) + invBlue * gamma;
                    min = 0.03f * f;
                    red = red * (0.99f - min) + min;
                    green = green * (0.99f - min) + min;
                    blue = blue * (0.99f - min) + min;
                    if (red > 1.0f) {
                        red = 1.0f;
                    }
                    if (green > 1.0f) {
                        green = 1.0f;
                    }
                    if (blue > 1.0f) {
                        blue = 1.0f;
                    }
                    if (red < 0.0f) {
                        red = 0.0f;
                    }
                    if (green < 0.0f) {
                        green = 0.0f;
                    }
                    if (blue < 0.0f) {
                        blue = 0.0f;
                    }
                    Darkness.LUMINANCE[blockIndex][skyIndex] = Darkness.luminance(red, green, blue);
                }
            }
        }
    }

    static {
        double fog;
        LOG = LogManager.getLogger((String)"Darkness");
        File configDir = FabricLoader.getInstance().getConfigDirectory();
        if (!configDir.exists()) {
            LOG.warn("[Darkness] Could not access configuration directory: " + configDir.getAbsolutePath());
        }
        File configFile = new File(configDir, "darkness.properties");
        Properties properties = new Properties();
        if (configFile.exists()) {
            try (FileInputStream stream = new FileInputStream(configFile);){
                properties.load(stream);
            }
            catch (IOException e) {
                LOG.warn("[Darkness] Could not read property file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        darkOverworld = properties.computeIfAbsent("dark_overworld", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        darkDefault = properties.computeIfAbsent("dark_default", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        darkNether = properties.computeIfAbsent("dark_nether", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        darkEnd = properties.computeIfAbsent("dark_end", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        darkSkyless = properties.computeIfAbsent("dark_skyless", (Function<? super Object, ?>)((Function<Object, Object>)a -> "true")).equals("true");
        double d = fog = darkNether ? 0.5 : 1.0;
        if (darkNether) {
            try {
                fog = Double.parseDouble(properties.computeIfAbsent("dark_nether_fog", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0.5")).toString());
                fog = class_3532.method_15350((double)fog, (double)0.0, (double)1.0);
            }
            catch (Exception e) {
                fog = 0.5;
                LOG.warn("Invalid configuration value for 'dark_nether_fog'. Using default value.");
            }
        }
        darkNetherFog = fog;
        double d2 = fog = darkEnd ? 0.0 : 1.0;
        if (darkEnd) {
            try {
                fog = Double.parseDouble(properties.computeIfAbsent("dark_end_fog", (Function<? super Object, ?>)((Function<Object, Object>)a -> "0.0")).toString());
                fog = class_3532.method_15350((double)fog, (double)0.0, (double)1.0);
            }
            catch (Exception e) {
                fog = 0.0;
                LOG.warn("Invalid configuration value for 'dark_end_fog'. Using default value.");
            }
        }
        darkEndFog = fog;
        try (FileOutputStream stream = new FileOutputStream(configFile);){
            properties.store(stream, "Darkness properties file");
        }
        catch (IOException e) {
            LOG.warn("[Indigo] Could not store property file '" + configFile.getAbsolutePath() + "'", (Throwable)e);
        }
        enabled = false;
        LUMINANCE = new float[16][16];
    }
}

