/*
 * Decompiled with CFR 0.152.
 */
package divinerpg;

import divinerpg.api.armor.registry.IArmorDescription;
import divinerpg.capabilities.item.DivineItemStackCapability;
import divinerpg.capabilities.item.DivineItemStackCapabilityStorage;
import divinerpg.compat.JERCompat;
import divinerpg.compat.ProjectECompat;
import divinerpg.config.GeneralConfig;
import divinerpg.events.ArcanaTickHandler;
import divinerpg.events.DimensionHelper;
import divinerpg.events.EventEntityDrop;
import divinerpg.events.enchants.WorldBreakEnchantHandler;
import divinerpg.proxy.CommonProxy;
import divinerpg.registry.EntitySpawnRegistry;
import divinerpg.registry.LiquidRegistry;
import divinerpg.registry.MessageRegistry;
import divinerpg.registry.OreDictionaryHandler;
import divinerpg.registry.SmeltingRecipeRegistry;
import divinerpg.registry.TriggerRegistry;
import divinerpg.utils.UpdateChecker;
import divinerpg.utils.Utils;
import divinerpg.utils.attributes.AttributeFixer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.registries.RegistryBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="divinerpg", name="DivineRPG", version="1.7", updateJSON="https://raw.githubusercontent.com/DivineRPG/DivineRPG/1.12.2/divinerpg_update.json", acceptedMinecraftVersions="[1.12.2]")
public class DivineRPG {
    public static final String MODID = "divinerpg";
    public static final String NAME = "DivineRPG";
    public static final String VERSION = "1.7";
    public static final String UPDATE_URL = "https://raw.githubusercontent.com/DivineRPG/DivineRPG/1.12.2/divinerpg_update.json";
    @Mod.Instance
    public static DivineRPG instance;
    @SidedProxy(serverSide="divinerpg.proxy.CommonProxy", clientSide="divinerpg.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static SimpleNetworkWrapper network;

    public DivineRPG() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        logger = LogManager.getLogger();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        LiquidRegistry.registerFluids();
        proxy.preInit(event);
        proxy.registerTileEntities();
        MinecraftForge.EVENT_BUS.register((Object)new ArcanaTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EventEntityDrop());
        MinecraftForge.EVENT_BUS.register((Object)new WorldBreakEnchantHandler());
        MessageRegistry.initMessages();
        AttributeFixer.patchMaximumHealth();
        CapabilityManager.INSTANCE.register(DivineItemStackCapability.class, (Capability.IStorage)new DivineItemStackCapabilityStorage(), DivineItemStackCapability::new);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
        OreDictionaryHandler.registerOreDictionaryEntries();
        TriggerRegistry.registerTriggers();
        SmeltingRecipeRegistry.registerSmeltingRecipes();
        MinecraftForge.EVENT_BUS.register((Object)new GeneralConfig());
        if (Loader.isModLoaded((String)"jeresources")) {
            JERCompat.onInit(e);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
        if (Loader.isModLoaded((String)"projecte")) {
            ProjectECompat.init();
        }
        EntitySpawnRegistry.initSpawns();
        Utils.loadHatInformation();
        DimensionHelper.initPortalDescriptions();
        UpdateChecker.checkForUpdates();
    }

    @SubscribeEvent
    public void createRegistries(RegistryEvent.NewRegistry event) {
        logger.info("Creating registries");
        new RegistryBuilder().setName(new ResourceLocation(MODID, "armor_descriptions")).setType(IArmorDescription.class).create();
    }

    static {
        network = new SimpleNetworkWrapper(MODID);
        FluidRegistry.enableUniversalBucket();
    }
}

