/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.arcana.mazegen;

import divinerpg.dimensions.arcana.mazegen.Cell;
import divinerpg.dimensions.arcana.mazegen.MazeMapMemoryStorage;
import divinerpg.dimensions.arcana.mazegen.UnionFind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.util.math.ChunkPos;

public class ArcanaMazeGenerator {
    public static final int MAZE_SIZE = 64;

    public static Cell[][] generate(int chunkX, int chunkZ, long worldSeed) {
        int y;
        int x;
        Random random = new Random();
        random.setSeed(worldSeed);
        long k = random.nextLong() / 2L * 2L + 1L;
        long l = random.nextLong() / 2L * 2L + 1L;
        random.setSeed((long)chunkX * k + (long)chunkZ * l ^ worldSeed);
        Cell[][] grid = new Cell[64][64];
        ArrayList<Edge> edges = new ArrayList<Edge>();
        UnionFind<Integer> unionFind = new UnionFind<Integer>();
        for (x = 0; x < 64; ++x) {
            for (y = 0; y < 64; ++y) {
                Cell cell;
                grid[x][y] = cell = new Cell(x, y);
                unionFind.add(cell.identifier);
            }
        }
        for (x = 1; x < 64; ++x) {
            for (y = 0; y < 64; ++y) {
                edges.add(new Edge(grid[x - 1][y], grid[x][y], Edge.Direction.HORIZONTAL));
            }
        }
        for (x = 0; x < 64; ++x) {
            for (y = 1; y < 64; ++y) {
                edges.add(new Edge(grid[x][y - 1], grid[x][y], Edge.Direction.VERTICAL));
            }
        }
        Collections.shuffle(edges, random);
        for (Edge edge : edges) {
            Cell firstCell = edge.firstAdjacent;
            Cell secondCell = edge.secondAdjacent;
            if (unionFind.find(firstCell.identifier) == unionFind.find(secondCell.identifier)) continue;
            if (edge.direction == Edge.Direction.HORIZONTAL) {
                firstCell.hasSouthEdge = false;
                secondCell.hasNorthEdge = false;
            } else {
                firstCell.hasEastEdge = false;
                secondCell.hasWestEdge = false;
            }
            unionFind.union(firstCell.identifier, secondCell.identifier);
        }
        return grid;
    }

    public static Cell obtainMazePiece(int chunkX, int chunkZ, long worldSeed) {
        int mapCoordinateZ;
        int mapCoordinateX;
        Cell[][] mazeMap;
        int regionRootZ;
        int regionRootX = ArcanaMazeGenerator.roundUpToMultiple(chunkX, 64);
        ChunkPos regionRoot = new ChunkPos(regionRootX, regionRootZ = ArcanaMazeGenerator.roundUpToMultiple(chunkZ, 64));
        Cell[][] storedGrid = MazeMapMemoryStorage.getMapForChunkPos(regionRoot);
        if (storedGrid == null) {
            mazeMap = ArcanaMazeGenerator.generate(regionRootX, regionRootZ, worldSeed);
            MazeMapMemoryStorage.addMap(regionRoot, mazeMap);
        } else {
            mazeMap = storedGrid;
        }
        if (chunkX <= 0) {
            mapCoordinateX = Math.abs(chunkX % 64);
        } else {
            mapCoordinateX = 64 - chunkX % 64;
            if (mapCoordinateX == 64) {
                mapCoordinateX = 0;
            }
        }
        if (chunkZ <= 0) {
            mapCoordinateZ = Math.abs(chunkZ % 64);
        } else {
            mapCoordinateZ = 64 - chunkZ % 64;
            if (mapCoordinateZ == 64) {
                mapCoordinateZ = 0;
            }
        }
        Cell cell = mazeMap[mapCoordinateZ][mapCoordinateX];
        return cell;
    }

    private static int roundUpToMultiple(int numToRound, int multiple) {
        if (multiple == 0) {
            return numToRound;
        }
        int remainder = Math.abs(numToRound) % multiple;
        if (remainder == 0) {
            return numToRound;
        }
        if (numToRound < 0) {
            return -1 * (Math.abs(numToRound) - remainder);
        }
        return numToRound + multiple - remainder;
    }

    private static class Edge {
        Cell firstAdjacent;
        Cell secondAdjacent;
        Direction direction;

        Edge(Cell firstAdjacent, Cell secondAdjacent, Direction direction) {
            this.firstAdjacent = firstAdjacent;
            this.secondAdjacent = secondAdjacent;
            this.direction = direction;
        }

        static enum Direction {
            HORIZONTAL,
            VERTICAL;

        }
    }
}

