/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.iceika;

import divinerpg.registry.BlockRegistry;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitNoiseGensEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class IceikaTerrainGenerator {
    private World world;
    private Random random;
    private final double[] heightMap;
    private double[] mainNoiseRegion;
    private double[] minLimitRegion;
    private double[] maxLimitRegion;
    private double[] depthRegion;
    private NoiseGeneratorOctaves minLimitPerlinNoise;
    private NoiseGeneratorOctaves maxLimitPerlinNoise;
    private NoiseGeneratorOctaves mainPerlinNoise;
    private NoiseGeneratorPerlin surfaceNoise;
    private NoiseGeneratorOctaves depthNoise;
    private final float[] biomeWeights;
    private double[] depthBuffer = new double[256];
    private Biome[] biomesForGeneration;

    public IceikaTerrainGenerator() {
        this.heightMap = new double[825];
        this.biomeWeights = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.biomeWeights[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
    }

    public void setBiomesForGeneration(Biome[] biomesForGeneration) {
        this.biomesForGeneration = biomesForGeneration;
    }

    public void setup(World world, Random rand) {
        this.world = world;
        this.random = rand;
        this.minLimitPerlinNoise = new NoiseGeneratorOctaves(rand, 16);
        this.maxLimitPerlinNoise = new NoiseGeneratorOctaves(rand, 16);
        this.mainPerlinNoise = new NoiseGeneratorOctaves(rand, 8);
        this.surfaceNoise = new NoiseGeneratorPerlin(rand, 4);
        NoiseGeneratorOctaves noiseGen5 = new NoiseGeneratorOctaves(rand, 10);
        this.depthNoise = new NoiseGeneratorOctaves(rand, 16);
        NoiseGeneratorOctaves mobSpawnerNoise = new NoiseGeneratorOctaves(rand, 8);
        InitNoiseGensEvent.ContextOverworld ctx = new InitNoiseGensEvent.ContextOverworld(this.minLimitPerlinNoise, this.maxLimitPerlinNoise, this.mainPerlinNoise, this.surfaceNoise, noiseGen5, this.depthNoise, mobSpawnerNoise);
        ctx = (InitNoiseGensEvent.ContextOverworld)TerrainGen.getModdedNoiseGenerators((World)world, (Random)rand, (InitNoiseGensEvent.Context)ctx);
        this.minLimitPerlinNoise = ctx.getLPerlin1();
        this.maxLimitPerlinNoise = ctx.getLPerlin2();
        this.mainPerlinNoise = ctx.getPerlin();
        this.surfaceNoise = ctx.getHeight();
        this.depthNoise = ctx.getDepth();
    }

    private void generateHeightmap(int chunkX4, int chunkY4, int chunkZ4) {
        this.depthRegion = this.depthNoise.func_76305_a(this.depthRegion, chunkX4, chunkZ4, 5, 5, 200.0, 200.0, 0.5);
        this.mainNoiseRegion = this.mainPerlinNoise.func_76304_a(this.mainNoiseRegion, chunkX4, chunkY4, chunkZ4, 5, 33, 5, 8.55515, 4.277575, 8.55515);
        this.minLimitRegion = this.minLimitPerlinNoise.func_76304_a(this.minLimitRegion, chunkX4, chunkY4, chunkZ4, 5, 33, 5, 684.412, 684.412, 684.412);
        this.maxLimitRegion = this.maxLimitPerlinNoise.func_76304_a(this.maxLimitRegion, chunkX4, chunkY4, chunkZ4, 5, 33, 5, 684.412, 684.412, 684.412);
        int l = 0;
        int i1 = 0;
        for (int j1 = 0; j1 < 5; ++j1) {
            for (int k1 = 0; k1 < 5; ++k1) {
                float f = 0.0f;
                float f1 = 0.0f;
                float f2 = 0.0f;
                int b0 = 2;
                for (int l1 = -b0; l1 <= b0; ++l1) {
                    for (int i2 = -b0; i2 <= b0; ++i2) {
                        Biome biome = this.biomesForGeneration[j1 + 2 + (k1 + 2) * 10];
                        float baseHeight = biome.func_185355_j();
                        float variation = biome.func_185360_m();
                        float f5 = this.biomeWeights[l1 + 2 + (i2 + 2) * 5] / (baseHeight + 2.0f);
                        f += variation * f5;
                        f1 += baseHeight * f5;
                        f2 += f5;
                    }
                }
                f /= f2;
                f1 /= f2;
                f = f * 0.9f + 0.1f;
                f1 = (f1 * 4.0f - 1.0f) / 8.0f;
                double d12 = this.depthRegion[i1] / 8000.0;
                if (d12 < 0.0) {
                    d12 = -d12 * 0.3;
                }
                if ((d12 = d12 * 3.0 - 2.0) < 0.0) {
                    if ((d12 /= 2.0) < -1.0) {
                        d12 = -1.0;
                    }
                    d12 /= 1.4;
                    d12 /= 2.0;
                } else {
                    if (d12 > 1.0) {
                        d12 = 1.0;
                    }
                    d12 /= 8.0;
                }
                ++i1;
                double d13 = f1;
                double d14 = f;
                d13 += d12 * 0.2;
                d13 = d13 * 8.5 / 8.0;
                double d5 = 8.5 + d13 * 4.0;
                for (int j2 = 0; j2 < 33; ++j2) {
                    double d6 = ((double)j2 - d5) * 12.0 * 128.0 / 256.0 / d14;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.minLimitRegion[l] / 512.0;
                    double d8 = this.maxLimitRegion[l] / 512.0;
                    double d9 = (this.mainNoiseRegion[l] / 10.0 + 1.0) / 2.0;
                    double d10 = MathHelper.func_151237_a((double)d7, (double)d8, (double)d9) - d6;
                    if (j2 > 29) {
                        double d11 = (float)(j2 - 29) / 3.0f;
                        d10 = d10 * (1.0 - d11) + -10.0 * d11;
                    }
                    this.heightMap[l] = d10;
                    ++l;
                }
            }
        }
    }

    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.generateHeightmap(chunkX * 4, 0, chunkZ * 4);
        int waterLevel = 70;
        for (int x4 = 0; x4 < 4; ++x4) {
            int l = x4 * 5;
            int i1 = (x4 + 1) * 5;
            for (int z4 = 0; z4 < 4; ++z4) {
                int k1 = (l + z4) * 33;
                int l1 = (l + z4 + 1) * 33;
                int i2 = (i1 + z4) * 33;
                int j2 = (i1 + z4 + 1) * 33;
                for (int height32 = 0; height32 < 32; ++height32) {
                    double d0 = 0.125;
                    double d1 = this.heightMap[k1 + height32];
                    double d2 = this.heightMap[l1 + height32];
                    double d3 = this.heightMap[i2 + height32];
                    double d4 = this.heightMap[j2 + height32];
                    double d5 = (this.heightMap[k1 + height32 + 1] - d1) * d0;
                    double d6 = (this.heightMap[l1 + height32 + 1] - d2) * d0;
                    double d7 = (this.heightMap[i2 + height32 + 1] - d3) * d0;
                    double d8 = (this.heightMap[j2 + height32 + 1] - d4) * d0;
                    for (int h = 0; h < 8; ++h) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        int height = height32 * 8 + h;
                        for (int x = 0; x < 4; ++x) {
                            double d14 = 0.25;
                            double d16 = (d11 - d10) * d14;
                            double d15 = d10 - d16;
                            for (int z = 0; z < 4; ++z) {
                                double d;
                                if (height < 2) {
                                    primer.func_177855_a(x4 * 4 + x, height32 * 8 + h, z4 * 4 + z, Blocks.field_150357_h.func_176223_P());
                                    continue;
                                }
                                d15 += d16;
                                if (!(d > 0.0)) continue;
                                primer.func_177855_a(x4 * 4 + x, height32 * 8 + h, z4 * 4 + z, BlockRegistry.frozenStone.func_176223_P());
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, IChunkGenerator generator, Biome[] biomes) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)generator, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomes[j + i * 16];
                biome.func_180622_a(this.world, this.random, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }
}

