/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils.attributes;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IReflectionHelper {
    @Nullable
    default public Field findField(@Nonnull Object instance, String name) {
        return this.findField(instance.getClass(), name);
    }

    default public boolean trySetPrivateStaticValue(Class<?> holderClass, String name, Object newValue) {
        return this.trySetPrivateValue(holderClass, null, name, newValue);
    }

    default public boolean trySetPrivateValue(@Nonnull Object instance, String name, Object newValue) {
        return this.trySetPrivateValue(instance.getClass(), instance, name, newValue);
    }

    default public boolean trySetPrivateValue(Class<?> holderClass, @Nullable Object instance, String name, Object newValue) {
        Field field = this.findField(holderClass, name);
        if (field != null) {
            try {
                field.set(instance, newValue);
                return true;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    default public Field setAccessible(@Nonnull Field field) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        if ((field.getModifiers() & 0x10) != 0) {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        return field;
    }

    @Nullable
    public Field findField(@Nonnull Class<?> var1, @Nonnull String var2);

    @Nullable
    public Method findMethod(@Nonnull Class<?> var1, @Nonnull String var2, Class ... var3);

    default public Object callMethod(@Nonnull Object instance, @Nonnull String name, Supplier<Object[]> func, Class ... params) {
        return this.callMethod(instance.getClass(), instance, name, func, params);
    }

    default public Object callMethod(Class<?> classToFind, @Nullable Object instance, @Nonnull String name, Supplier<Object[]> func, Class ... params) {
        Method method = this.findMethod(classToFind, name, params);
        try {
            if (method != null) {
                return method.invoke(instance, func.get());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }
}

